variable "aws_profile" {
  default = "twitch-sandstorm-infra-aws"
}

variable "kms_key_ids" {
  type = "map"

  default = {
    production = "60e0f97f-eeca-4834-b146-7ac9fb20fd74"
    staging    = "7e35716a-dc00-47e8-a596-cc990555f7b5"
    testing    = "ec100850-4cca-43c8-88c4-320a3bf98600"
  }
}

variable "name" {}
variable "env" {}

variable "assume_role_identifiers" {
  type    = "list"
  default = []
}

variable "aws_account_id" {
  default = "734326455073"
}

provider "aws" {
  alias   = "twitch-sandstorm-infra-aws"
  region  = "us-west-2"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_id}",
  ]
}

output "role_arn" {
  value = "${aws_iam_role.sandstorm-rw.arn}"
}

output "role_name" {
  value = "${aws_iam_role.sandstorm-rw.name}"
}
