package testutil

import (
	"fmt"
	"io/ioutil"

	"github.com/hashicorp/hcl"
	uuid "github.com/satori/go.uuid"
)

// Config for testing
type Config struct {
	Sandstorm struct {
		Profile               string
		TableName             string
		KeyID                 string `hcl:"key_id"`
		DDBStatsdHostPort     string `hcl:"ddb_statsd_host_port"`
		DDBStatsdPrefix       string `hcl:"ddb_statsd_prefix"`
		RoleArn               string `hcl:"role_arn"`
		Region                string
		InventoryAdminRoleARN string `hcl:"inventory_admin_role_arn"`
		InventoryRoleARN      string `hcl:"inventory_role_arn"`
		InventoryStatusURL    string `hcl:"inventory_status_url"`
		ServiceName           string `hcl:"service_name"`
	}
}

// GetRandomSecretName gives a random secret for usage in tests.
// Please delete after test.
func GetRandomSecretName() string {
	return GetRandomSecretNameWithPrefix("system/testService/testing")
}

// GetRandomSecretNameWithPrefix gives a random secret for usage in tests.
// Please delete after test.
func GetRandomSecretNameWithPrefix(prefix string) string {
	return fmt.Sprintf("%s/%s", prefix, uuid.NewV4().String())
}

// GetRandomGroupName gives a random group name for usage in tests.
// Please delete after test.
func GetRandomGroupName() string {
	return fmt.Sprintf("sandstorm-api-test-group-%s", uuid.NewV4().String())
}

// LoadTestConfig gets configuration used for tests
func LoadTestConfig() (*Config, error) {
	return LoadTestConfigFromFile("../test.hcl")
}

// LoadTestConfigFromFile gets configuration used for tests from filename
func LoadTestConfigFromFile(filename string) (*Config, error) {
	b, err := ioutil.ReadFile(filename)
	if err != nil {
		return nil, err
	}
	var out Config
	err = hcl.Decode(&out, string(b))
	if err := hcl.Decode(&out, string(b)); err != nil {
		return nil, err
	}
	return &out, nil
}
