# Nice / Naiive
Naiive is a tool and a library for constructing quick-and-dirty regex based static analysis tests. Regexes always have their issues,
since they don't understand the syntax of the program they operate on.

Nice is a static analysis framework that naiive is built on, and eventually a static analysis tool with similar dynamics to naiive,
but higher confidence.

## Naiive Quickstart

```bash
go get -u code.justin.tv/tshadwell/nice/cmd/naiive
naiive scan net/http
naiive search -r 'Request' net/http # output is a lil ugly, still working on this one!
```

Ensure `$GOPATH/bin` is in your $PATH!

## Go Test Integration

Naiive has a cool dual function in that it's super easy to integrate as a `go test`. The syntax is a little ugly but it'll get better, check it:

```go
import "testing"
import "code.justin.tv/tshadwell/nice"
import "code.justin.tv/tshadwell/nice/naiive"

func TestNaiive(t *testing.T) {
	nice.test(t, naiive.DefaultTests)
}
```

Naiive might be naiive but it's smart and auto-detects the package it's being run from :)
