package main

import (
	"flag"
	"fmt"
	"os"
	"path/filepath"
	"regexp"
	"strconv"
	"strings"

	"github.com/google/subcommands"
)

var reLocateFlagAnno = regexp.MustCompile("`[^`]+`")

func invocationReference(s subcommands.Command, preamble, postamble string) string {
	preamble = filepath.Base(os.Args[0]) + " [global flags] " + s.Name() + preamble

	var bits []string
	if preamble != "" {
		bits = append(bits, fmt.Sprintf("%s", preamble))
	}

	var tmpFs = flag.NewFlagSet("tmp-getflags", 0) // errorHandling doesnt matter since mock
	s.SetFlags(tmpFs)

	tmpFs.VisitAll(func(f *flag.Flag) {
		exemplar := strings.Trim(reLocateFlagAnno.FindString(f.Usage), "`")
		if exemplar != "" {
			exemplar = " " + exemplar
		}

		bits = append(bits, fmt.Sprintf("[-%s%s]", f.Name, exemplar))
	})

	if postamble != "" {
		bits = append(bits, postamble)
	}

	return strings.Join(bits, " ")

}

func listify(connector string, s []string) string {
	switch len(s) {
	case 1:
		return s[0]
	case 2:
		return strings.Join(s, ", ")
	}

	return strings.Join(s[:len(s)-1], ", ") + " " + connector + " " + s[len(s)-1]
}

func quotedListify(connector string, s []string) string { return listify(connector, quoteList(s)) }

// quotes every string in s
// DOES NOT return a copy
func quoteList(s []string) (out []string) {
	out = make([]string, len(s), len(s))
	for i := range s {
		out[i] = strconv.Quote(s[i])
	}

	return out
}
