package main

import (
	"context"
	"flag"
	"os"

	_ "github.com/golang/glog"
	"github.com/google/subcommands"
)

func main() {
	flag.Parse()
	if err := do(); err != nil {
		panic(err)
	}
}

func do() (err error) {
	for _, c := range [...]subcommands.Command{subcommands.HelpCommand(), subcommands.FlagsCommand(), subcommands.CommandsCommand()} {
		subcommands.Register(c, "")
	}

	subcommands.ImportantFlag("v")
	subcommands.ImportantFlag("logtostderr")

	ctx := context.Background()
	os.Exit(int(subcommands.Execute(ctx)))

	return
}
