package nice

import "fmt"

type Confidence int

const (
	errorConfidence Confidence = iota
	LowConfidence
	MediumConfidence
	HighConfidence
	errorMaxConfidence
)

var reverseConfidence = map[string]Confidence{
	"low":    LowConfidence,
	"medium": MediumConfidence,
	"high":   HighConfidence,
}
var confidenceOptions = []string{"error (max)", "low", "medium", "high", "error (min)"}

func (c Confidence) String() string                         { return confidenceOptions[int(c)] }
func (Confidence) AllowedValues() []string                  { return confidenceOptions[1 : len(confidenceOptions)-1] }
func (c Confidence) MarshalText() (text []byte, err error)  { return []byte(c.String()), nil }
func (c *Confidence) UnmarshalText(text []byte) (err error) { return c.Set(string(text)) }

func (c *Confidence) Set(text string) (err error) {
	var ok bool
	*c, ok = reverseConfidence[text]
	if !ok {
		return fmt.Errorf("cannot unmarshal unknown confidence type %+q", text)
	}

	return
}

type Severity int

const (
	errorSeverity Severity = iota
	LowSeverity
	MediumSeverity
	HighSeverity
	errorMaxSeverity
)

var reverseSeverity = map[string]Severity{
	"low":    LowSeverity,
	"medium": MediumSeverity,
	"high":   HighSeverity,
}
var severityOptions = confidenceOptions

func (s Severity) String() string                         { return severityOptions[int(s)] }
func (Severity) AllowedValues() []string                  { return severityOptions[1 : len(severityOptions)-1] }
func (s Severity) MarshalText() (text []byte, err error)  { return []byte(s.String()), nil }
func (s *Severity) UnmarshalText(text []byte) (err error) { return s.Set(string(text)) }

func (s *Severity) Set(text string) (err error) {
	var ok bool
	*s, ok = reverseSeverity[text]
	if !ok {
		return fmt.Errorf("cannot unmarshal unknown severity type %+q", text)
	}

	return
}
