package naiive

import (
	"regexp"
	"testing"

	"code.justin.tv/tshadwell/nice"
)

func TestRegexMatch(t *testing.T) {
	for _, test := range DefaultTests {
		for _, pve := range test.Examples {
			if !test.MatchString(pve) {
				t.Errorf("test %s failed: regexp %s doesn't match %s", test.Name, test.Regexp, pve)
			}
		}

		for _, nve := range test.NonExamples {
			if test.MatchString(nve) {
				t.Errorf("test %s failed: regexp %s does match %s", test.Name, test.Regexp, nve)
			}
		}
	}
}

func Example(t *testing.T) {
	nice.Test(t, DefaultTests)
}

func TestLineNumber(t *testing.T) {
	if err := testLineNumber(t); err != nil {
		t.Fatal(err)
	}
}

func testLineNumber(t *testing.T) (err error) {
	prog, err := nice.FromString(`/*1*/package main
/*2*/
/*3*/	func ImportantLine() {}
/*4*/	func main() {}
/*5*/`)
	if err != nil {
		return
	}
	defer prog.Close()

	findings, err := (&TestConfig{
		IncludeStdLib: false,
		Tests: []Test{
			{
				Regexp: regexp.MustCompile("ImportantLine"),
			},
		},
	}).NiceTest(prog.Program)

	if err != nil {
		return
	}

	if findings[0].Position[0].Line != 3 {
		t.FailNow()
	}

	return
}
