package nice

import (
	"testing"
)

func TestLoad(t *testing.T) {
	const pkgPath = "code.justin.tv/tshadwell/nice"
	p := new(Program)

	ld, err := p.Ast()
	if err != nil {
		t.Fatal(err)
	}

	t.Logf("imported packages: %+v", ld.Imported)

	if _, ok := ld.Imported[pkgPath]; !ok {
		t.Fatalf("failed to load %s", pkgPath)
	}
}
