// +build none

package query

import "golang.org/x/tools/go/ssa"

type query struct {
	Roots map[Node]bool
}

type selector interface {
	Name() string
	Match(*ssa.Node) (bool, error)
	ChildSelectors() map[Node]bool
	Select(Node) Node
}

/* query.Compile(
	query.ByInterface {
		Interface: http.Server(nil),
		Then: [...]
	},

	query.ByParams {
		Params: { query.AssignableTo(http.ResponseWriter(nil)), query.AssignableTo(new(http.Request)) }
		Limit: 4,
		MatchType: query.All // (query.Any)
		Then: query.
	}
)


query.Select(ByFuncParams {
	Func: func(http.ResponseWriter, *http.Request) {}
	Match: query.Some,
	ParamLimit: 3,
})

.Select(*ssa.If{

})


*/
type Selection interface {
	Select(interface{}) Selection
	SelectFunc(func(node *ssa.Node) bool) Selection
	Children() []Selection
}

func Select(value interface{}) {
}
