package nice

import "testing"

func _TestTestBulldozingError(t *testing.T) {
	if err := testTestBulldozingError(t); err != nil {
		t.Fatal(err)
	}
}

func testTestBulldozingError(t *testing.T) (err error) {
	prog, err := FromString(`package main

import "context"
import "net/http"

func SomeErrorHandlingFunction(err error) {}

type Bad struct {}
func (Bad) dontDoThis(c *context.Context, rw http.ResponseWriter, r *http.Request) {
	var err error

	if err != nil {
		SomeErrorHandlingFunction(err)
		// oops!
	}
}
		`)

	if err != nil {
		return
	}

	defer prog.Close()

	byt, err := prog.DumpSsa()
	if err != nil {
		return
	}

	t.Logf("%s\n", byt)
	panic("hi")

	findings, err := TestBulldozingError.NiceTest(prog.Program)
	if err != nil {
		return
	}

	t.Fatalf("%+v", findings)

	return
}
