// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/AddTagsToResource
func (c *CloudHSM) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTagsToResource API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Adds or overwrites one or more tags for the specified AWS CloudHSM resource.
//
// Each tag consists of a key and a value. Tag keys must be unique to each resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/AddTagsToResource
func (c *CloudHSM) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHapg = "CreateHapg"

// CreateHapgRequest generates a "aws/request.Request" representing the
// client's request for the CreateHapg operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHapg for more information on using the CreateHapg
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHapgRequest method.
//    req, resp := client.CreateHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHapg
func (c *CloudHSM) CreateHapgRequest(input *CreateHapgInput) (req *request.Request, output *CreateHapgOutput) {
	op := &request.Operation{
		Name:       opCreateHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHapgInput{}
	}

	output = &CreateHapgOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHapg API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Creates a high-availability partition group. A high-availability partition
// group is a group of partitions that spans multiple physical HSMs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation CreateHapg for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHapg
func (c *CloudHSM) CreateHapg(input *CreateHapgInput) (*CreateHapgOutput, error) {
	req, out := c.CreateHapgRequest(input)
	return out, req.Send()
}

// CreateHapgWithContext is the same as CreateHapg with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHapg for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) CreateHapgWithContext(ctx aws.Context, input *CreateHapgInput, opts ...request.Option) (*CreateHapgOutput, error) {
	req, out := c.CreateHapgRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHsm = "CreateHsm"

// CreateHsmRequest generates a "aws/request.Request" representing the
// client's request for the CreateHsm operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHsm for more information on using the CreateHsm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHsmRequest method.
//    req, resp := client.CreateHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHsm
func (c *CloudHSM) CreateHsmRequest(input *CreateHsmInput) (req *request.Request, output *CreateHsmOutput) {
	op := &request.Operation{
		Name:       opCreateHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmInput{}
	}

	output = &CreateHsmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHsm API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Creates an uninitialized HSM instance.
//
// There is an upfront fee charged for each HSM instance that you create with
// the CreateHsm operation. If you accidentally provision an HSM and want to
// request a refund, delete the instance using the DeleteHsm operation, go to
// the AWS Support Center (https://console.aws.amazon.com/support/home), create
// a new case, and select Account and Billing Support.
//
// It can take up to 20 minutes to create and provision an HSM. You can monitor
// the status of the HSM with the DescribeHsm operation. The HSM is ready to
// be initialized when the status changes to RUNNING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation CreateHsm for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHsm
func (c *CloudHSM) CreateHsm(input *CreateHsmInput) (*CreateHsmOutput, error) {
	req, out := c.CreateHsmRequest(input)
	return out, req.Send()
}

// CreateHsmWithContext is the same as CreateHsm with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHsm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) CreateHsmWithContext(ctx aws.Context, input *CreateHsmInput, opts ...request.Option) (*CreateHsmOutput, error) {
	req, out := c.CreateHsmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLunaClient = "CreateLunaClient"

// CreateLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the CreateLunaClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLunaClient for more information on using the CreateLunaClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLunaClientRequest method.
//    req, resp := client.CreateLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateLunaClient
func (c *CloudHSM) CreateLunaClientRequest(input *CreateLunaClientInput) (req *request.Request, output *CreateLunaClientOutput) {
	op := &request.Operation{
		Name:       opCreateLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLunaClientInput{}
	}

	output = &CreateLunaClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLunaClient API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Creates an HSM client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation CreateLunaClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateLunaClient
func (c *CloudHSM) CreateLunaClient(input *CreateLunaClientInput) (*CreateLunaClientOutput, error) {
	req, out := c.CreateLunaClientRequest(input)
	return out, req.Send()
}

// CreateLunaClientWithContext is the same as CreateLunaClient with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLunaClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) CreateLunaClientWithContext(ctx aws.Context, input *CreateLunaClientInput, opts ...request.Option) (*CreateLunaClientOutput, error) {
	req, out := c.CreateLunaClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHapg = "DeleteHapg"

// DeleteHapgRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHapg operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHapg for more information on using the DeleteHapg
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHapgRequest method.
//    req, resp := client.DeleteHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapg
func (c *CloudHSM) DeleteHapgRequest(input *DeleteHapgInput) (req *request.Request, output *DeleteHapgOutput) {
	op := &request.Operation{
		Name:       opDeleteHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHapgInput{}
	}

	output = &DeleteHapgOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteHapg API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Deletes a high-availability partition group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DeleteHapg for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapg
func (c *CloudHSM) DeleteHapg(input *DeleteHapgInput) (*DeleteHapgOutput, error) {
	req, out := c.DeleteHapgRequest(input)
	return out, req.Send()
}

// DeleteHapgWithContext is the same as DeleteHapg with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHapg for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) DeleteHapgWithContext(ctx aws.Context, input *DeleteHapgInput, opts ...request.Option) (*DeleteHapgOutput, error) {
	req, out := c.DeleteHapgRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHsm = "DeleteHsm"

// DeleteHsmRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHsm operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHsm for more information on using the DeleteHsm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHsmRequest method.
//    req, resp := client.DeleteHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsm
func (c *CloudHSM) DeleteHsmRequest(input *DeleteHsmInput) (req *request.Request, output *DeleteHsmOutput) {
	op := &request.Operation{
		Name:       opDeleteHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmInput{}
	}

	output = &DeleteHsmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteHsm API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Deletes an HSM. After completion, this operation cannot be undone and your
// key material cannot be recovered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DeleteHsm for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsm
func (c *CloudHSM) DeleteHsm(input *DeleteHsmInput) (*DeleteHsmOutput, error) {
	req, out := c.DeleteHsmRequest(input)
	return out, req.Send()
}

// DeleteHsmWithContext is the same as DeleteHsm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHsm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) DeleteHsmWithContext(ctx aws.Context, input *DeleteHsmInput, opts ...request.Option) (*DeleteHsmOutput, error) {
	req, out := c.DeleteHsmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLunaClient = "DeleteLunaClient"

// DeleteLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLunaClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLunaClient for more information on using the DeleteLunaClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLunaClientRequest method.
//    req, resp := client.DeleteLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteLunaClient
func (c *CloudHSM) DeleteLunaClientRequest(input *DeleteLunaClientInput) (req *request.Request, output *DeleteLunaClientOutput) {
	op := &request.Operation{
		Name:       opDeleteLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLunaClientInput{}
	}

	output = &DeleteLunaClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLunaClient API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Deletes a client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DeleteLunaClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteLunaClient
func (c *CloudHSM) DeleteLunaClient(input *DeleteLunaClientInput) (*DeleteLunaClientOutput, error) {
	req, out := c.DeleteLunaClientRequest(input)
	return out, req.Send()
}

// DeleteLunaClientWithContext is the same as DeleteLunaClient with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLunaClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) DeleteLunaClientWithContext(ctx aws.Context, input *DeleteLunaClientInput, opts ...request.Option) (*DeleteLunaClientOutput, error) {
	req, out := c.DeleteLunaClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHapg = "DescribeHapg"

// DescribeHapgRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHapg operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHapg for more information on using the DescribeHapg
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHapgRequest method.
//    req, resp := client.DescribeHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapg
func (c *CloudHSM) DescribeHapgRequest(input *DescribeHapgInput) (req *request.Request, output *DescribeHapgOutput) {
	op := &request.Operation{
		Name:       opDescribeHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHapgInput{}
	}

	output = &DescribeHapgOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHapg API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Retrieves information about a high-availability partition group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DescribeHapg for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapg
func (c *CloudHSM) DescribeHapg(input *DescribeHapgInput) (*DescribeHapgOutput, error) {
	req, out := c.DescribeHapgRequest(input)
	return out, req.Send()
}

// DescribeHapgWithContext is the same as DescribeHapg with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHapg for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) DescribeHapgWithContext(ctx aws.Context, input *DescribeHapgInput, opts ...request.Option) (*DescribeHapgOutput, error) {
	req, out := c.DescribeHapgRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHsm = "DescribeHsm"

// DescribeHsmRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHsm operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHsm for more information on using the DescribeHsm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHsmRequest method.
//    req, resp := client.DescribeHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsm
func (c *CloudHSM) DescribeHsmRequest(input *DescribeHsmInput) (req *request.Request, output *DescribeHsmOutput) {
	op := &request.Operation{
		Name:       opDescribeHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHsmInput{}
	}

	output = &DescribeHsmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHsm API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Retrieves information about an HSM. You can identify the HSM by its ARN or
// its serial number.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DescribeHsm for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsm
func (c *CloudHSM) DescribeHsm(input *DescribeHsmInput) (*DescribeHsmOutput, error) {
	req, out := c.DescribeHsmRequest(input)
	return out, req.Send()
}

// DescribeHsmWithContext is the same as DescribeHsm with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHsm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) DescribeHsmWithContext(ctx aws.Context, input *DescribeHsmInput, opts ...request.Option) (*DescribeHsmOutput, error) {
	req, out := c.DescribeHsmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLunaClient = "DescribeLunaClient"

// DescribeLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLunaClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLunaClient for more information on using the DescribeLunaClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLunaClientRequest method.
//    req, resp := client.DescribeLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClient
func (c *CloudHSM) DescribeLunaClientRequest(input *DescribeLunaClientInput) (req *request.Request, output *DescribeLunaClientOutput) {
	op := &request.Operation{
		Name:       opDescribeLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLunaClientInput{}
	}

	output = &DescribeLunaClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLunaClient API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Retrieves information about an HSM client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DescribeLunaClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClient
func (c *CloudHSM) DescribeLunaClient(input *DescribeLunaClientInput) (*DescribeLunaClientOutput, error) {
	req, out := c.DescribeLunaClientRequest(input)
	return out, req.Send()
}

// DescribeLunaClientWithContext is the same as DescribeLunaClient with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLunaClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) DescribeLunaClientWithContext(ctx aws.Context, input *DescribeLunaClientInput, opts ...request.Option) (*DescribeLunaClientOutput, error) {
	req, out := c.DescribeLunaClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfig = "GetConfig"

// GetConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfig for more information on using the GetConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConfigRequest method.
//    req, resp := client.GetConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfig
func (c *CloudHSM) GetConfigRequest(input *GetConfigInput) (req *request.Request, output *GetConfigOutput) {
	op := &request.Operation{
		Name:       opGetConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConfigInput{}
	}

	output = &GetConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfig API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Gets the configuration files necessary to connect to all high availability
// partition groups the client is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation GetConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfig
func (c *CloudHSM) GetConfig(input *GetConfigInput) (*GetConfigOutput, error) {
	req, out := c.GetConfigRequest(input)
	return out, req.Send()
}

// GetConfigWithContext is the same as GetConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) GetConfigWithContext(ctx aws.Context, input *GetConfigInput, opts ...request.Option) (*GetConfigOutput, error) {
	req, out := c.GetConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableZones = "ListAvailableZones"

// ListAvailableZonesRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableZones operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableZones for more information on using the ListAvailableZones
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAvailableZonesRequest method.
//    req, resp := client.ListAvailableZonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZones
func (c *CloudHSM) ListAvailableZonesRequest(input *ListAvailableZonesInput) (req *request.Request, output *ListAvailableZonesOutput) {
	op := &request.Operation{
		Name:       opListAvailableZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableZonesInput{}
	}

	output = &ListAvailableZonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableZones API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Lists the Availability Zones that have available AWS CloudHSM capacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListAvailableZones for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZones
func (c *CloudHSM) ListAvailableZones(input *ListAvailableZonesInput) (*ListAvailableZonesOutput, error) {
	req, out := c.ListAvailableZonesRequest(input)
	return out, req.Send()
}

// ListAvailableZonesWithContext is the same as ListAvailableZones with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableZones for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ListAvailableZonesWithContext(ctx aws.Context, input *ListAvailableZonesInput, opts ...request.Option) (*ListAvailableZonesOutput, error) {
	req, out := c.ListAvailableZonesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHapgs = "ListHapgs"

// ListHapgsRequest generates a "aws/request.Request" representing the
// client's request for the ListHapgs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHapgs for more information on using the ListHapgs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHapgsRequest method.
//    req, resp := client.ListHapgsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgs
func (c *CloudHSM) ListHapgsRequest(input *ListHapgsInput) (req *request.Request, output *ListHapgsOutput) {
	op := &request.Operation{
		Name:       opListHapgs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHapgsInput{}
	}

	output = &ListHapgsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHapgs API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Lists the high-availability partition groups for the account.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListHapgs to retrieve the next
// set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListHapgs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgs
func (c *CloudHSM) ListHapgs(input *ListHapgsInput) (*ListHapgsOutput, error) {
	req, out := c.ListHapgsRequest(input)
	return out, req.Send()
}

// ListHapgsWithContext is the same as ListHapgs with the addition of
// the ability to pass a context and additional request options.
//
// See ListHapgs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ListHapgsWithContext(ctx aws.Context, input *ListHapgsInput, opts ...request.Option) (*ListHapgsOutput, error) {
	req, out := c.ListHapgsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHsms = "ListHsms"

// ListHsmsRequest generates a "aws/request.Request" representing the
// client's request for the ListHsms operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHsms for more information on using the ListHsms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHsmsRequest method.
//    req, resp := client.ListHsmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsms
func (c *CloudHSM) ListHsmsRequest(input *ListHsmsInput) (req *request.Request, output *ListHsmsOutput) {
	op := &request.Operation{
		Name:       opListHsms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHsmsInput{}
	}

	output = &ListHsmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHsms API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Retrieves the identifiers of all of the HSMs provisioned for the current
// customer.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListHsms to retrieve the next set
// of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListHsms for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsms
func (c *CloudHSM) ListHsms(input *ListHsmsInput) (*ListHsmsOutput, error) {
	req, out := c.ListHsmsRequest(input)
	return out, req.Send()
}

// ListHsmsWithContext is the same as ListHsms with the addition of
// the ability to pass a context and additional request options.
//
// See ListHsms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ListHsmsWithContext(ctx aws.Context, input *ListHsmsInput, opts ...request.Option) (*ListHsmsOutput, error) {
	req, out := c.ListHsmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLunaClients = "ListLunaClients"

// ListLunaClientsRequest generates a "aws/request.Request" representing the
// client's request for the ListLunaClients operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLunaClients for more information on using the ListLunaClients
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLunaClientsRequest method.
//    req, resp := client.ListLunaClientsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClients
func (c *CloudHSM) ListLunaClientsRequest(input *ListLunaClientsInput) (req *request.Request, output *ListLunaClientsOutput) {
	op := &request.Operation{
		Name:       opListLunaClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLunaClientsInput{}
	}

	output = &ListLunaClientsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLunaClients API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Lists all of the clients.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListLunaClients to retrieve the
// next set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListLunaClients for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClients
func (c *CloudHSM) ListLunaClients(input *ListLunaClientsInput) (*ListLunaClientsOutput, error) {
	req, out := c.ListLunaClientsRequest(input)
	return out, req.Send()
}

// ListLunaClientsWithContext is the same as ListLunaClients with the addition of
// the ability to pass a context and additional request options.
//
// See ListLunaClients for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ListLunaClientsWithContext(ctx aws.Context, input *ListLunaClientsInput, opts ...request.Option) (*ListLunaClientsOutput, error) {
	req, out := c.ListLunaClientsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListTagsForResource
func (c *CloudHSM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Returns a list of all tags for the specified AWS CloudHSM resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListTagsForResource
func (c *CloudHSM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyHapg = "ModifyHapg"

// ModifyHapgRequest generates a "aws/request.Request" representing the
// client's request for the ModifyHapg operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyHapg for more information on using the ModifyHapg
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyHapgRequest method.
//    req, resp := client.ModifyHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapg
func (c *CloudHSM) ModifyHapgRequest(input *ModifyHapgInput) (req *request.Request, output *ModifyHapgOutput) {
	op := &request.Operation{
		Name:       opModifyHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHapgInput{}
	}

	output = &ModifyHapgOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyHapg API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Modifies an existing high-availability partition group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ModifyHapg for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapg
func (c *CloudHSM) ModifyHapg(input *ModifyHapgInput) (*ModifyHapgOutput, error) {
	req, out := c.ModifyHapgRequest(input)
	return out, req.Send()
}

// ModifyHapgWithContext is the same as ModifyHapg with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyHapg for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ModifyHapgWithContext(ctx aws.Context, input *ModifyHapgInput, opts ...request.Option) (*ModifyHapgOutput, error) {
	req, out := c.ModifyHapgRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyHsm = "ModifyHsm"

// ModifyHsmRequest generates a "aws/request.Request" representing the
// client's request for the ModifyHsm operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyHsm for more information on using the ModifyHsm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyHsmRequest method.
//    req, resp := client.ModifyHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsm
func (c *CloudHSM) ModifyHsmRequest(input *ModifyHsmInput) (req *request.Request, output *ModifyHsmOutput) {
	op := &request.Operation{
		Name:       opModifyHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHsmInput{}
	}

	output = &ModifyHsmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyHsm API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Modifies an HSM.
//
// This operation can result in the HSM being offline for up to 15 minutes while
// the AWS CloudHSM service is reconfigured. If you are modifying a production
// HSM, you should ensure that your AWS CloudHSM service is configured for high
// availability, and consider executing this operation during a maintenance
// window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ModifyHsm for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsm
func (c *CloudHSM) ModifyHsm(input *ModifyHsmInput) (*ModifyHsmOutput, error) {
	req, out := c.ModifyHsmRequest(input)
	return out, req.Send()
}

// ModifyHsmWithContext is the same as ModifyHsm with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyHsm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ModifyHsmWithContext(ctx aws.Context, input *ModifyHsmInput, opts ...request.Option) (*ModifyHsmOutput, error) {
	req, out := c.ModifyHsmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyLunaClient = "ModifyLunaClient"

// ModifyLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the ModifyLunaClient operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyLunaClient for more information on using the ModifyLunaClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyLunaClientRequest method.
//    req, resp := client.ModifyLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClient
func (c *CloudHSM) ModifyLunaClientRequest(input *ModifyLunaClientInput) (req *request.Request, output *ModifyLunaClientOutput) {
	op := &request.Operation{
		Name:       opModifyLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyLunaClientInput{}
	}

	output = &ModifyLunaClientOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyLunaClient API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Modifies the certificate used by the client.
//
// This action can potentially start a workflow to install the new certificate
// on the client's HSMs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ModifyLunaClient for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClient
func (c *CloudHSM) ModifyLunaClient(input *ModifyLunaClientInput) (*ModifyLunaClientOutput, error) {
	req, out := c.ModifyLunaClientRequest(input)
	return out, req.Send()
}

// ModifyLunaClientWithContext is the same as ModifyLunaClient with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyLunaClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) ModifyLunaClientWithContext(ctx aws.Context, input *ModifyLunaClientInput, opts ...request.Option) (*ModifyLunaClientOutput, error) {
	req, out := c.ModifyLunaClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/RemoveTagsFromResource
func (c *CloudHSM) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTagsFromResource API operation for Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Removes one or more tags from the specified AWS CloudHSM resource.
//
// To remove a tag, specify only the tag key to remove (not the value). To overwrite
// the value for an existing tag, use AddTagsToResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCloudHsmServiceException "CloudHsmServiceException"
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * ErrCodeCloudHsmInternalException "CloudHsmInternalException"
//   Indicates that an internal error occurred.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Indicates that one or more of the request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/RemoveTagsFromResource
func (c *CloudHSM) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudHSM) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/AddTagsToResourceRequest
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// One or more tags.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AddTagsToResourceInput) SetResourceArn(v string) *AddTagsToResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *AddTagsToResourceInput) SetTagList(v []*Tag) *AddTagsToResourceInput {
	s.TagList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/AddTagsToResourceResponse
type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`

	// The status of the operation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AddTagsToResourceOutput) SetStatus(v string) *AddTagsToResourceOutput {
	s.Status = &v
	return s
}

// Contains the inputs for the CreateHapgRequest action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHapgRequest
type CreateHapgInput struct {
	_ struct{} `type:"structure"`

	// The label of the new high-availability partition group.
	//
	// Label is a required field
	Label *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHapgInput"}
	if s.Label == nil {
		invalidParams.Add(request.NewErrParamRequired("Label"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabel sets the Label field's value.
func (s *CreateHapgInput) SetLabel(v string) *CreateHapgInput {
	s.Label = &v
	return s
}

// Contains the output of the CreateHAPartitionGroup action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHapgResponse
type CreateHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`
}

// String returns the string representation
func (s CreateHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHapgOutput) GoString() string {
	return s.String()
}

// SetHapgArn sets the HapgArn field's value.
func (s *CreateHapgOutput) SetHapgArn(v string) *CreateHapgOutput {
	s.HapgArn = &v
	return s
}

// Contains the inputs for the CreateHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHsmRequest
type CreateHsmInput struct {
	_ struct{} `locationName:"CreateHsmRequest" type:"structure"`

	// A user-defined token to ensure idempotence. Subsequent calls to this operation
	// with the same token will be ignored.
	ClientToken *string `locationName:"ClientToken" type:"string"`

	// The IP address to assign to the HSM's ENI.
	//
	// If an IP address is not specified, an IP address will be randomly chosen
	// from the CIDR range of the subnet.
	EniIp *string `locationName:"EniIp" type:"string"`

	// The external ID from IamRoleArn, if present.
	ExternalId *string `locationName:"ExternalId" type:"string"`

	// The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
	// ENI on your behalf.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `locationName:"IamRoleArn" type:"string" required:"true"`

	// The SSH public key to install on the HSM.
	//
	// SshKey is a required field
	SshKey *string `locationName:"SshKey" type:"string" required:"true"`

	// The identifier of the subnet in your VPC in which to place the HSM.
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"SubnetId" type:"string" required:"true"`

	// Specifies the type of subscription for the HSM.
	//
	//    * PRODUCTION - The HSM is being used in a production environment.
	//
	//    * TRIAL - The HSM is being used in a product trial.
	//
	// SubscriptionType is a required field
	SubscriptionType *string `locationName:"SubscriptionType" type:"string" required:"true" enum:"SubscriptionType"`

	// The IP address for the syslog monitoring server. The AWS CloudHSM service
	// only supports one syslog monitoring server.
	SyslogIp *string `locationName:"SyslogIp" type:"string"`
}

// String returns the string representation
func (s CreateHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHsmInput"}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.SshKey == nil {
		invalidParams.Add(request.NewErrParamRequired("SshKey"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubscriptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateHsmInput) SetClientToken(v string) *CreateHsmInput {
	s.ClientToken = &v
	return s
}

// SetEniIp sets the EniIp field's value.
func (s *CreateHsmInput) SetEniIp(v string) *CreateHsmInput {
	s.EniIp = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *CreateHsmInput) SetExternalId(v string) *CreateHsmInput {
	s.ExternalId = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateHsmInput) SetIamRoleArn(v string) *CreateHsmInput {
	s.IamRoleArn = &v
	return s
}

// SetSshKey sets the SshKey field's value.
func (s *CreateHsmInput) SetSshKey(v string) *CreateHsmInput {
	s.SshKey = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateHsmInput) SetSubnetId(v string) *CreateHsmInput {
	s.SubnetId = &v
	return s
}

// SetSubscriptionType sets the SubscriptionType field's value.
func (s *CreateHsmInput) SetSubscriptionType(v string) *CreateHsmInput {
	s.SubscriptionType = &v
	return s
}

// SetSyslogIp sets the SyslogIp field's value.
func (s *CreateHsmInput) SetSyslogIp(v string) *CreateHsmInput {
	s.SyslogIp = &v
	return s
}

// Contains the output of the CreateHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHsmResponse
type CreateHsmOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`
}

// String returns the string representation
func (s CreateHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmOutput) GoString() string {
	return s.String()
}

// SetHsmArn sets the HsmArn field's value.
func (s *CreateHsmOutput) SetHsmArn(v string) *CreateHsmOutput {
	s.HsmArn = &v
	return s
}

// Contains the inputs for the CreateLunaClient action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateLunaClientRequest
type CreateLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The contents of a Base64-Encoded X.509 v3 certificate to be installed on
	// the HSMs used by this client.
	//
	// Certificate is a required field
	Certificate *string `min:"600" type:"string" required:"true"`

	// The label for the client.
	Label *string `type:"string"`
}

// String returns the string representation
func (s CreateLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLunaClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLunaClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLunaClientInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(*s.Certificate) < 600 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 600))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *CreateLunaClientInput) SetCertificate(v string) *CreateLunaClientInput {
	s.Certificate = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *CreateLunaClientInput) SetLabel(v string) *CreateLunaClientInput {
	s.Label = &v
	return s
}

// Contains the output of the CreateLunaClient action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateLunaClientResponse
type CreateLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLunaClientOutput) GoString() string {
	return s.String()
}

// SetClientArn sets the ClientArn field's value.
func (s *CreateLunaClientOutput) SetClientArn(v string) *CreateLunaClientOutput {
	s.ClientArn = &v
	return s
}

// Contains the inputs for the DeleteHapg action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapgRequest
type DeleteHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to delete.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHapgInput"}
	if s.HapgArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHapgArn sets the HapgArn field's value.
func (s *DeleteHapgInput) SetHapgArn(v string) *DeleteHapgInput {
	s.HapgArn = &v
	return s
}

// Contains the output of the DeleteHapg action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapgResponse
type DeleteHapgOutput struct {
	_ struct{} `type:"structure"`

	// The status of the action.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHapgOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteHapgOutput) SetStatus(v string) *DeleteHapgOutput {
	s.Status = &v
	return s
}

// Contains the inputs for the DeleteHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsmRequest
type DeleteHsmInput struct {
	_ struct{} `locationName:"DeleteHsmRequest" type:"structure"`

	// The ARN of the HSM to delete.
	//
	// HsmArn is a required field
	HsmArn *string `locationName:"HsmArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHsmInput"}
	if s.HsmArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHsmArn sets the HsmArn field's value.
func (s *DeleteHsmInput) SetHsmArn(v string) *DeleteHsmInput {
	s.HsmArn = &v
	return s
}

// Contains the output of the DeleteHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsmResponse
type DeleteHsmOutput struct {
	_ struct{} `type:"structure"`

	// The status of the operation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteHsmOutput) SetStatus(v string) *DeleteHsmOutput {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteLunaClientRequest
type DeleteLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client to delete.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLunaClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLunaClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLunaClientInput"}
	if s.ClientArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientArn sets the ClientArn field's value.
func (s *DeleteLunaClientInput) SetClientArn(v string) *DeleteLunaClientInput {
	s.ClientArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteLunaClientResponse
type DeleteLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The status of the action.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLunaClientOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteLunaClientOutput) SetStatus(v string) *DeleteLunaClientOutput {
	s.Status = &v
	return s
}

// Contains the inputs for the DescribeHapg action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapgRequest
type DescribeHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to describe.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHapgInput"}
	if s.HapgArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHapgArn sets the HapgArn field's value.
func (s *DescribeHapgInput) SetHapgArn(v string) *DescribeHapgInput {
	s.HapgArn = &v
	return s
}

// Contains the output of the DescribeHapg action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapgResponse
type DescribeHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`

	// The serial number of the high-availability partition group.
	HapgSerial *string `type:"string"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsLastActionFailed []*string `type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsPendingDeletion []*string `type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsPendingRegistration []*string `type:"list"`

	// The label for the high-availability partition group.
	Label *string `type:"string"`

	// The date and time the high-availability partition group was last modified.
	LastModifiedTimestamp *string `type:"string"`

	// The list of partition serial numbers that belong to the high-availability
	// partition group.
	PartitionSerialList []*string `type:"list"`

	// The state of the high-availability partition group.
	State *string `type:"string" enum:"CloudHsmObjectState"`
}

// String returns the string representation
func (s DescribeHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHapgOutput) GoString() string {
	return s.String()
}

// SetHapgArn sets the HapgArn field's value.
func (s *DescribeHapgOutput) SetHapgArn(v string) *DescribeHapgOutput {
	s.HapgArn = &v
	return s
}

// SetHapgSerial sets the HapgSerial field's value.
func (s *DescribeHapgOutput) SetHapgSerial(v string) *DescribeHapgOutput {
	s.HapgSerial = &v
	return s
}

// SetHsmsLastActionFailed sets the HsmsLastActionFailed field's value.
func (s *DescribeHapgOutput) SetHsmsLastActionFailed(v []*string) *DescribeHapgOutput {
	s.HsmsLastActionFailed = v
	return s
}

// SetHsmsPendingDeletion sets the HsmsPendingDeletion field's value.
func (s *DescribeHapgOutput) SetHsmsPendingDeletion(v []*string) *DescribeHapgOutput {
	s.HsmsPendingDeletion = v
	return s
}

// SetHsmsPendingRegistration sets the HsmsPendingRegistration field's value.
func (s *DescribeHapgOutput) SetHsmsPendingRegistration(v []*string) *DescribeHapgOutput {
	s.HsmsPendingRegistration = v
	return s
}

// SetLabel sets the Label field's value.
func (s *DescribeHapgOutput) SetLabel(v string) *DescribeHapgOutput {
	s.Label = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *DescribeHapgOutput) SetLastModifiedTimestamp(v string) *DescribeHapgOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetPartitionSerialList sets the PartitionSerialList field's value.
func (s *DescribeHapgOutput) SetPartitionSerialList(v []*string) *DescribeHapgOutput {
	s.PartitionSerialList = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeHapgOutput) SetState(v string) *DescribeHapgOutput {
	s.State = &v
	return s
}

// Contains the inputs for the DescribeHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsmRequest
type DescribeHsmInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM. Either the HsmArn or the SerialNumber parameter must
	// be specified.
	HsmArn *string `type:"string"`

	// The serial number of the HSM. Either the HsmArn or the HsmSerialNumber parameter
	// must be specified.
	HsmSerialNumber *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmInput) GoString() string {
	return s.String()
}

// SetHsmArn sets the HsmArn field's value.
func (s *DescribeHsmInput) SetHsmArn(v string) *DescribeHsmInput {
	s.HsmArn = &v
	return s
}

// SetHsmSerialNumber sets the HsmSerialNumber field's value.
func (s *DescribeHsmInput) SetHsmSerialNumber(v string) *DescribeHsmInput {
	s.HsmSerialNumber = &v
	return s
}

// Contains the output of the DescribeHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsmResponse
type DescribeHsmOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that the HSM is in.
	AvailabilityZone *string `type:"string"`

	// The identifier of the elastic network interface (ENI) attached to the HSM.
	EniId *string `type:"string"`

	// The IP address assigned to the HSM's ENI.
	EniIp *string `type:"string"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`

	// The HSM model type.
	HsmType *string `type:"string"`

	// The ARN of the IAM role assigned to the HSM.
	IamRoleArn *string `type:"string"`

	// The list of partitions on the HSM.
	Partitions []*string `type:"list"`

	// The serial number of the HSM.
	SerialNumber *string `type:"string"`

	// The date and time that the server certificate was last updated.
	ServerCertLastUpdated *string `type:"string"`

	// The URI of the certificate server.
	ServerCertUri *string `type:"string"`

	// The HSM software version.
	SoftwareVersion *string `type:"string"`

	// The date and time that the SSH key was last updated.
	SshKeyLastUpdated *string `type:"string"`

	// The public SSH key.
	SshPublicKey *string `type:"string"`

	// The status of the HSM.
	Status *string `type:"string" enum:"HsmStatus"`

	// Contains additional information about the status of the HSM.
	StatusDetails *string `type:"string"`

	// The identifier of the subnet that the HSM is in.
	SubnetId *string `type:"string"`

	// The subscription end date.
	SubscriptionEndDate *string `type:"string"`

	// The subscription start date.
	SubscriptionStartDate *string `type:"string"`

	// Specifies the type of subscription for the HSM.
	//
	//    * PRODUCTION - The HSM is being used in a production environment.
	//
	//    * TRIAL - The HSM is being used in a product trial.
	SubscriptionType *string `type:"string" enum:"SubscriptionType"`

	// The name of the HSM vendor.
	VendorName *string `type:"string"`

	// The identifier of the VPC that the HSM is in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DescribeHsmOutput) SetAvailabilityZone(v string) *DescribeHsmOutput {
	s.AvailabilityZone = &v
	return s
}

// SetEniId sets the EniId field's value.
func (s *DescribeHsmOutput) SetEniId(v string) *DescribeHsmOutput {
	s.EniId = &v
	return s
}

// SetEniIp sets the EniIp field's value.
func (s *DescribeHsmOutput) SetEniIp(v string) *DescribeHsmOutput {
	s.EniIp = &v
	return s
}

// SetHsmArn sets the HsmArn field's value.
func (s *DescribeHsmOutput) SetHsmArn(v string) *DescribeHsmOutput {
	s.HsmArn = &v
	return s
}

// SetHsmType sets the HsmType field's value.
func (s *DescribeHsmOutput) SetHsmType(v string) *DescribeHsmOutput {
	s.HsmType = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *DescribeHsmOutput) SetIamRoleArn(v string) *DescribeHsmOutput {
	s.IamRoleArn = &v
	return s
}

// SetPartitions sets the Partitions field's value.
func (s *DescribeHsmOutput) SetPartitions(v []*string) *DescribeHsmOutput {
	s.Partitions = v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *DescribeHsmOutput) SetSerialNumber(v string) *DescribeHsmOutput {
	s.SerialNumber = &v
	return s
}

// SetServerCertLastUpdated sets the ServerCertLastUpdated field's value.
func (s *DescribeHsmOutput) SetServerCertLastUpdated(v string) *DescribeHsmOutput {
	s.ServerCertLastUpdated = &v
	return s
}

// SetServerCertUri sets the ServerCertUri field's value.
func (s *DescribeHsmOutput) SetServerCertUri(v string) *DescribeHsmOutput {
	s.ServerCertUri = &v
	return s
}

// SetSoftwareVersion sets the SoftwareVersion field's value.
func (s *DescribeHsmOutput) SetSoftwareVersion(v string) *DescribeHsmOutput {
	s.SoftwareVersion = &v
	return s
}

// SetSshKeyLastUpdated sets the SshKeyLastUpdated field's value.
func (s *DescribeHsmOutput) SetSshKeyLastUpdated(v string) *DescribeHsmOutput {
	s.SshKeyLastUpdated = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *DescribeHsmOutput) SetSshPublicKey(v string) *DescribeHsmOutput {
	s.SshPublicKey = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeHsmOutput) SetStatus(v string) *DescribeHsmOutput {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *DescribeHsmOutput) SetStatusDetails(v string) *DescribeHsmOutput {
	s.StatusDetails = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DescribeHsmOutput) SetSubnetId(v string) *DescribeHsmOutput {
	s.SubnetId = &v
	return s
}

// SetSubscriptionEndDate sets the SubscriptionEndDate field's value.
func (s *DescribeHsmOutput) SetSubscriptionEndDate(v string) *DescribeHsmOutput {
	s.SubscriptionEndDate = &v
	return s
}

// SetSubscriptionStartDate sets the SubscriptionStartDate field's value.
func (s *DescribeHsmOutput) SetSubscriptionStartDate(v string) *DescribeHsmOutput {
	s.SubscriptionStartDate = &v
	return s
}

// SetSubscriptionType sets the SubscriptionType field's value.
func (s *DescribeHsmOutput) SetSubscriptionType(v string) *DescribeHsmOutput {
	s.SubscriptionType = &v
	return s
}

// SetVendorName sets the VendorName field's value.
func (s *DescribeHsmOutput) SetVendorName(v string) *DescribeHsmOutput {
	s.VendorName = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeHsmOutput) SetVpcId(v string) *DescribeHsmOutput {
	s.VpcId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClientRequest
type DescribeLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLunaClientInput) GoString() string {
	return s.String()
}

// SetCertificateFingerprint sets the CertificateFingerprint field's value.
func (s *DescribeLunaClientInput) SetCertificateFingerprint(v string) *DescribeLunaClientInput {
	s.CertificateFingerprint = &v
	return s
}

// SetClientArn sets the ClientArn field's value.
func (s *DescribeLunaClientInput) SetClientArn(v string) *DescribeLunaClientInput {
	s.ClientArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClientResponse
type DescribeLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The certificate installed on the HSMs used by this client.
	Certificate *string `min:"600" type:"string"`

	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientArn *string `type:"string"`

	// The label of the client.
	Label *string `type:"string"`

	// The date and time the client was last modified.
	LastModifiedTimestamp *string `type:"string"`
}

// String returns the string representation
func (s DescribeLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLunaClientOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *DescribeLunaClientOutput) SetCertificate(v string) *DescribeLunaClientOutput {
	s.Certificate = &v
	return s
}

// SetCertificateFingerprint sets the CertificateFingerprint field's value.
func (s *DescribeLunaClientOutput) SetCertificateFingerprint(v string) *DescribeLunaClientOutput {
	s.CertificateFingerprint = &v
	return s
}

// SetClientArn sets the ClientArn field's value.
func (s *DescribeLunaClientOutput) SetClientArn(v string) *DescribeLunaClientOutput {
	s.ClientArn = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *DescribeLunaClientOutput) SetLabel(v string) *DescribeLunaClientOutput {
	s.Label = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *DescribeLunaClientOutput) SetLastModifiedTimestamp(v string) *DescribeLunaClientOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfigRequest
type GetConfigInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`

	// The client version.
	//
	// ClientVersion is a required field
	ClientVersion *string `type:"string" required:"true" enum:"ClientVersion"`

	// A list of ARNs that identify the high-availability partition groups that
	// are associated with the client.
	//
	// HapgList is a required field
	HapgList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigInput"}
	if s.ClientArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientArn"))
	}
	if s.ClientVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientVersion"))
	}
	if s.HapgList == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientArn sets the ClientArn field's value.
func (s *GetConfigInput) SetClientArn(v string) *GetConfigInput {
	s.ClientArn = &v
	return s
}

// SetClientVersion sets the ClientVersion field's value.
func (s *GetConfigInput) SetClientVersion(v string) *GetConfigInput {
	s.ClientVersion = &v
	return s
}

// SetHapgList sets the HapgList field's value.
func (s *GetConfigInput) SetHapgList(v []*string) *GetConfigInput {
	s.HapgList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfigResponse
type GetConfigOutput struct {
	_ struct{} `type:"structure"`

	// The certificate file containing the server.pem files of the HSMs.
	ConfigCred *string `type:"string"`

	// The chrystoki.conf configuration file.
	ConfigFile *string `type:"string"`

	// The type of credentials.
	ConfigType *string `type:"string"`
}

// String returns the string representation
func (s GetConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigOutput) GoString() string {
	return s.String()
}

// SetConfigCred sets the ConfigCred field's value.
func (s *GetConfigOutput) SetConfigCred(v string) *GetConfigOutput {
	s.ConfigCred = &v
	return s
}

// SetConfigFile sets the ConfigFile field's value.
func (s *GetConfigOutput) SetConfigFile(v string) *GetConfigOutput {
	s.ConfigFile = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *GetConfigOutput) SetConfigType(v string) *GetConfigOutput {
	s.ConfigType = &v
	return s
}

// Contains the inputs for the ListAvailableZones action.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZonesRequest
type ListAvailableZonesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListAvailableZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableZonesInput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZonesResponse
type ListAvailableZonesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones that have available AWS CloudHSM capacity.
	AZList []*string `type:"list"`
}

// String returns the string representation
func (s ListAvailableZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableZonesOutput) GoString() string {
	return s.String()
}

// SetAZList sets the AZList field's value.
func (s *ListAvailableZonesOutput) SetAZList(v []*string) *ListAvailableZonesOutput {
	s.AZList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgsRequest
type ListHapgsInput struct {
	_ struct{} `type:"structure"`

	// The NextToken value from a previous call to ListHapgs. Pass null if this
	// is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHapgsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHapgsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListHapgsInput) SetNextToken(v string) *ListHapgsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgsResponse
type ListHapgsOutput struct {
	_ struct{} `type:"structure"`

	// The list of high-availability partition groups.
	//
	// HapgList is a required field
	HapgList []*string `type:"list" required:"true"`

	// If not null, more results are available. Pass this value to ListHapgs to
	// retrieve the next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHapgsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHapgsOutput) GoString() string {
	return s.String()
}

// SetHapgList sets the HapgList field's value.
func (s *ListHapgsOutput) SetHapgList(v []*string) *ListHapgsOutput {
	s.HapgList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHapgsOutput) SetNextToken(v string) *ListHapgsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsmsRequest
type ListHsmsInput struct {
	_ struct{} `type:"structure"`

	// The NextToken value from a previous call to ListHsms. Pass null if this is
	// the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHsmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHsmsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListHsmsInput) SetNextToken(v string) *ListHsmsInput {
	s.NextToken = &v
	return s
}

// Contains the output of the ListHsms operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsmsResponse
type ListHsmsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ARNs that identify the HSMs.
	HsmList []*string `type:"list"`

	// If not null, more results are available. Pass this value to ListHsms to retrieve
	// the next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHsmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHsmsOutput) GoString() string {
	return s.String()
}

// SetHsmList sets the HsmList field's value.
func (s *ListHsmsOutput) SetHsmList(v []*string) *ListHsmsOutput {
	s.HsmList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHsmsOutput) SetNextToken(v string) *ListHsmsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClientsRequest
type ListLunaClientsInput struct {
	_ struct{} `type:"structure"`

	// The NextToken value from a previous call to ListLunaClients. Pass null if
	// this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLunaClientsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLunaClientsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListLunaClientsInput) SetNextToken(v string) *ListLunaClientsInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClientsResponse
type ListLunaClientsOutput struct {
	_ struct{} `type:"structure"`

	// The list of clients.
	//
	// ClientList is a required field
	ClientList []*string `type:"list" required:"true"`

	// If not null, more results are available. Pass this to ListLunaClients to
	// retrieve the next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLunaClientsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLunaClientsOutput) GoString() string {
	return s.String()
}

// SetClientList sets the ClientList field's value.
func (s *ListLunaClientsOutput) SetClientList(v []*string) *ListLunaClientsOutput {
	s.ClientList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLunaClientsOutput) SetNextToken(v string) *ListLunaClientsOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListTagsForResourceRequest
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListTagsForResourceResponse
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// One or more tags.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapgRequest
type ModifyHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to modify.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`

	// The new label for the high-availability partition group.
	Label *string `type:"string"`

	// The list of partition serial numbers to make members of the high-availability
	// partition group.
	PartitionSerialList []*string `type:"list"`
}

// String returns the string representation
func (s ModifyHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyHapgInput"}
	if s.HapgArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHapgArn sets the HapgArn field's value.
func (s *ModifyHapgInput) SetHapgArn(v string) *ModifyHapgInput {
	s.HapgArn = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ModifyHapgInput) SetLabel(v string) *ModifyHapgInput {
	s.Label = &v
	return s
}

// SetPartitionSerialList sets the PartitionSerialList field's value.
func (s *ModifyHapgInput) SetPartitionSerialList(v []*string) *ModifyHapgInput {
	s.PartitionSerialList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapgResponse
type ModifyHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHapgOutput) GoString() string {
	return s.String()
}

// SetHapgArn sets the HapgArn field's value.
func (s *ModifyHapgOutput) SetHapgArn(v string) *ModifyHapgOutput {
	s.HapgArn = &v
	return s
}

// Contains the inputs for the ModifyHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsmRequest
type ModifyHsmInput struct {
	_ struct{} `locationName:"ModifyHsmRequest" type:"structure"`

	// The new IP address for the elastic network interface (ENI) attached to the
	// HSM.
	//
	// If the HSM is moved to a different subnet, and an IP address is not specified,
	// an IP address will be randomly chosen from the CIDR range of the new subnet.
	EniIp *string `locationName:"EniIp" type:"string"`

	// The new external ID.
	ExternalId *string `locationName:"ExternalId" type:"string"`

	// The ARN of the HSM to modify.
	//
	// HsmArn is a required field
	HsmArn *string `locationName:"HsmArn" type:"string" required:"true"`

	// The new IAM role ARN.
	IamRoleArn *string `locationName:"IamRoleArn" type:"string"`

	// The new identifier of the subnet that the HSM is in. The new subnet must
	// be in the same Availability Zone as the current subnet.
	SubnetId *string `locationName:"SubnetId" type:"string"`

	// The new IP address for the syslog monitoring server. The AWS CloudHSM service
	// only supports one syslog monitoring server.
	SyslogIp *string `locationName:"SyslogIp" type:"string"`
}

// String returns the string representation
func (s ModifyHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyHsmInput"}
	if s.HsmArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEniIp sets the EniIp field's value.
func (s *ModifyHsmInput) SetEniIp(v string) *ModifyHsmInput {
	s.EniIp = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ModifyHsmInput) SetExternalId(v string) *ModifyHsmInput {
	s.ExternalId = &v
	return s
}

// SetHsmArn sets the HsmArn field's value.
func (s *ModifyHsmInput) SetHsmArn(v string) *ModifyHsmInput {
	s.HsmArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *ModifyHsmInput) SetIamRoleArn(v string) *ModifyHsmInput {
	s.IamRoleArn = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *ModifyHsmInput) SetSubnetId(v string) *ModifyHsmInput {
	s.SubnetId = &v
	return s
}

// SetSyslogIp sets the SyslogIp field's value.
func (s *ModifyHsmInput) SetSyslogIp(v string) *ModifyHsmInput {
	s.SyslogIp = &v
	return s
}

// Contains the output of the ModifyHsm operation.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsmResponse
type ModifyHsmOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHsmOutput) GoString() string {
	return s.String()
}

// SetHsmArn sets the HsmArn field's value.
func (s *ModifyHsmOutput) SetHsmArn(v string) *ModifyHsmOutput {
	s.HsmArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClientRequest
type ModifyLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The new certificate for the client.
	//
	// Certificate is a required field
	Certificate *string `min:"600" type:"string" required:"true"`

	// The ARN of the client.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLunaClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyLunaClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyLunaClientInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(*s.Certificate) < 600 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 600))
	}
	if s.ClientArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *ModifyLunaClientInput) SetCertificate(v string) *ModifyLunaClientInput {
	s.Certificate = &v
	return s
}

// SetClientArn sets the ClientArn field's value.
func (s *ModifyLunaClientInput) SetClientArn(v string) *ModifyLunaClientInput {
	s.ClientArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClientResponse
type ModifyLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLunaClientOutput) GoString() string {
	return s.String()
}

// SetClientArn sets the ClientArn field's value.
func (s *ModifyLunaClientOutput) SetClientArn(v string) *ModifyLunaClientOutput {
	s.ClientArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/RemoveTagsFromResourceRequest
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag key or keys to remove.
	//
	// Specify only the tag key to remove (not the value). To overwrite the value
	// for an existing tag, use AddTagsToResource.
	//
	// TagKeyList is a required field
	TagKeyList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeyList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeyList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RemoveTagsFromResourceInput) SetResourceArn(v string) *RemoveTagsFromResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeyList sets the TagKeyList field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeyList(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeyList = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/RemoveTagsFromResourceResponse
type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`

	// The status of the operation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *RemoveTagsFromResourceOutput) SetStatus(v string) *RemoveTagsFromResourceOutput {
	s.Status = &v
	return s
}

// A key-value pair that identifies or specifies metadata about an AWS CloudHSM
// resource.
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

const (
	// ClientVersion51 is a ClientVersion enum value
	ClientVersion51 = "5.1"

	// ClientVersion53 is a ClientVersion enum value
	ClientVersion53 = "5.3"
)

const (
	// CloudHsmObjectStateReady is a CloudHsmObjectState enum value
	CloudHsmObjectStateReady = "READY"

	// CloudHsmObjectStateUpdating is a CloudHsmObjectState enum value
	CloudHsmObjectStateUpdating = "UPDATING"

	// CloudHsmObjectStateDegraded is a CloudHsmObjectState enum value
	CloudHsmObjectStateDegraded = "DEGRADED"
)

const (
	// HsmStatusPending is a HsmStatus enum value
	HsmStatusPending = "PENDING"

	// HsmStatusRunning is a HsmStatus enum value
	HsmStatusRunning = "RUNNING"

	// HsmStatusUpdating is a HsmStatus enum value
	HsmStatusUpdating = "UPDATING"

	// HsmStatusSuspended is a HsmStatus enum value
	HsmStatusSuspended = "SUSPENDED"

	// HsmStatusTerminating is a HsmStatus enum value
	HsmStatusTerminating = "TERMINATING"

	// HsmStatusTerminated is a HsmStatus enum value
	HsmStatusTerminated = "TERMINATED"

	// HsmStatusDegraded is a HsmStatus enum value
	HsmStatusDegraded = "DEGRADED"
)

// Specifies the type of subscription for the HSM.
//
//    * PRODUCTION - The HSM is being used in a production environment.
//
//    * TRIAL - The HSM is being used in a product trial.
const (
	// SubscriptionTypeProduction is a SubscriptionType enum value
	SubscriptionTypeProduction = "PRODUCTION"
)
