// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateContainer = "CreateContainer"

// CreateContainerRequest generates a "aws/request.Request" representing the
// client's request for the CreateContainer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContainer for more information on using the CreateContainer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContainerRequest method.
//    req, resp := client.CreateContainerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainer
func (c *MediaStore) CreateContainerRequest(input *CreateContainerInput) (req *request.Request, output *CreateContainerOutput) {
	op := &request.Operation{
		Name:       opCreateContainer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContainerInput{}
	}

	output = &CreateContainerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContainer API operation for AWS Elemental MediaStore.
//
// Creates a storage container to hold objects. A container is similar to a
// bucket in the Amazon S3 service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation CreateContainer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeContainerInUseException "ContainerInUseException"
//   Resource already exists or is being updated.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit has been exceeded.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainer
func (c *MediaStore) CreateContainer(input *CreateContainerInput) (*CreateContainerOutput, error) {
	req, out := c.CreateContainerRequest(input)
	return out, req.Send()
}

// CreateContainerWithContext is the same as CreateContainer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContainer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) CreateContainerWithContext(ctx aws.Context, input *CreateContainerInput, opts ...request.Option) (*CreateContainerOutput, error) {
	req, out := c.CreateContainerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContainer = "DeleteContainer"

// DeleteContainerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContainer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContainer for more information on using the DeleteContainer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContainerRequest method.
//    req, resp := client.DeleteContainerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainer
func (c *MediaStore) DeleteContainerRequest(input *DeleteContainerInput) (req *request.Request, output *DeleteContainerOutput) {
	op := &request.Operation{
		Name:       opDeleteContainer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContainerInput{}
	}

	output = &DeleteContainerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteContainer API operation for AWS Elemental MediaStore.
//
// Deletes the specified container. Before you make a DeleteContainer request,
// delete any objects in the container or in any folders in the container. You
// can delete only empty containers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DeleteContainer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeContainerInUseException "ContainerInUseException"
//   Resource already exists or is being updated.
//
//   * ErrCodeContainerNotFoundException "ContainerNotFoundException"
//   Could not perform an operation on a container that does not exist.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainer
func (c *MediaStore) DeleteContainer(input *DeleteContainerInput) (*DeleteContainerOutput, error) {
	req, out := c.DeleteContainerRequest(input)
	return out, req.Send()
}

// DeleteContainerWithContext is the same as DeleteContainer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContainer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DeleteContainerWithContext(ctx aws.Context, input *DeleteContainerInput, opts ...request.Option) (*DeleteContainerOutput, error) {
	req, out := c.DeleteContainerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContainerPolicy = "DeleteContainerPolicy"

// DeleteContainerPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContainerPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContainerPolicy for more information on using the DeleteContainerPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContainerPolicyRequest method.
//    req, resp := client.DeleteContainerPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicy
func (c *MediaStore) DeleteContainerPolicyRequest(input *DeleteContainerPolicyInput) (req *request.Request, output *DeleteContainerPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteContainerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContainerPolicyInput{}
	}

	output = &DeleteContainerPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteContainerPolicy API operation for AWS Elemental MediaStore.
//
// Deletes the access policy that is associated with the specified container.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DeleteContainerPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeContainerInUseException "ContainerInUseException"
//   Resource already exists or is being updated.
//
//   * ErrCodeContainerNotFoundException "ContainerNotFoundException"
//   Could not perform an operation on a container that does not exist.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   Could not perform an operation on a policy that does not exist.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicy
func (c *MediaStore) DeleteContainerPolicy(input *DeleteContainerPolicyInput) (*DeleteContainerPolicyOutput, error) {
	req, out := c.DeleteContainerPolicyRequest(input)
	return out, req.Send()
}

// DeleteContainerPolicyWithContext is the same as DeleteContainerPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContainerPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DeleteContainerPolicyWithContext(ctx aws.Context, input *DeleteContainerPolicyInput, opts ...request.Option) (*DeleteContainerPolicyOutput, error) {
	req, out := c.DeleteContainerPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContainer = "DescribeContainer"

// DescribeContainerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContainer operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContainer for more information on using the DescribeContainer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeContainerRequest method.
//    req, resp := client.DescribeContainerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainer
func (c *MediaStore) DescribeContainerRequest(input *DescribeContainerInput) (req *request.Request, output *DescribeContainerOutput) {
	op := &request.Operation{
		Name:       opDescribeContainer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContainerInput{}
	}

	output = &DescribeContainerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContainer API operation for AWS Elemental MediaStore.
//
// Retrieves the properties of the requested container. This returns a single
// Container object based on ContainerName. To return all Container objects
// that are associated with a specified AWS account, use ListContainers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation DescribeContainer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeContainerNotFoundException "ContainerNotFoundException"
//   Could not perform an operation on a container that does not exist.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainer
func (c *MediaStore) DescribeContainer(input *DescribeContainerInput) (*DescribeContainerOutput, error) {
	req, out := c.DescribeContainerRequest(input)
	return out, req.Send()
}

// DescribeContainerWithContext is the same as DescribeContainer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContainer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) DescribeContainerWithContext(ctx aws.Context, input *DescribeContainerInput, opts ...request.Option) (*DescribeContainerOutput, error) {
	req, out := c.DescribeContainerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContainerPolicy = "GetContainerPolicy"

// GetContainerPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetContainerPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContainerPolicy for more information on using the GetContainerPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContainerPolicyRequest method.
//    req, resp := client.GetContainerPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicy
func (c *MediaStore) GetContainerPolicyRequest(input *GetContainerPolicyInput) (req *request.Request, output *GetContainerPolicyOutput) {
	op := &request.Operation{
		Name:       opGetContainerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerPolicyInput{}
	}

	output = &GetContainerPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContainerPolicy API operation for AWS Elemental MediaStore.
//
// Retrieves the access policy for the specified container. For information
// about the data that is included in an access policy, see the AWS Identity
// and Access Management User Guide (https://aws.amazon.com/documentation/iam/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation GetContainerPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeContainerInUseException "ContainerInUseException"
//   Resource already exists or is being updated.
//
//   * ErrCodeContainerNotFoundException "ContainerNotFoundException"
//   Could not perform an operation on a container that does not exist.
//
//   * ErrCodePolicyNotFoundException "PolicyNotFoundException"
//   Could not perform an operation on a policy that does not exist.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicy
func (c *MediaStore) GetContainerPolicy(input *GetContainerPolicyInput) (*GetContainerPolicyOutput, error) {
	req, out := c.GetContainerPolicyRequest(input)
	return out, req.Send()
}

// GetContainerPolicyWithContext is the same as GetContainerPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetContainerPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) GetContainerPolicyWithContext(ctx aws.Context, input *GetContainerPolicyInput, opts ...request.Option) (*GetContainerPolicyOutput, error) {
	req, out := c.GetContainerPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListContainers = "ListContainers"

// ListContainersRequest generates a "aws/request.Request" representing the
// client's request for the ListContainers operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContainers for more information on using the ListContainers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListContainersRequest method.
//    req, resp := client.ListContainersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers
func (c *MediaStore) ListContainersRequest(input *ListContainersInput) (req *request.Request, output *ListContainersOutput) {
	op := &request.Operation{
		Name:       opListContainers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListContainersInput{}
	}

	output = &ListContainersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContainers API operation for AWS Elemental MediaStore.
//
// Lists the properties of all containers in AWS Elemental MediaStore.
//
// You can query to receive all the containers in one response. Or you can include
// the MaxResults parameter to receive a limited number of containers in each
// response. In this case, the response includes a token. To get the next set
// of containers, send the command again, this time with the NextToken parameter
// (with the returned token as its value). The next set of responses appears,
// with a token if there are still more containers to receive.
//
// See also DescribeContainer, which gets the properties of one container.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation ListContainers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers
func (c *MediaStore) ListContainers(input *ListContainersInput) (*ListContainersOutput, error) {
	req, out := c.ListContainersRequest(input)
	return out, req.Send()
}

// ListContainersWithContext is the same as ListContainers with the addition of
// the ability to pass a context and additional request options.
//
// See ListContainers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) ListContainersWithContext(ctx aws.Context, input *ListContainersInput, opts ...request.Option) (*ListContainersOutput, error) {
	req, out := c.ListContainersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutContainerPolicy = "PutContainerPolicy"

// PutContainerPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutContainerPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutContainerPolicy for more information on using the PutContainerPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutContainerPolicyRequest method.
//    req, resp := client.PutContainerPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicy
func (c *MediaStore) PutContainerPolicyRequest(input *PutContainerPolicyInput) (req *request.Request, output *PutContainerPolicyOutput) {
	op := &request.Operation{
		Name:       opPutContainerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutContainerPolicyInput{}
	}

	output = &PutContainerPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutContainerPolicy API operation for AWS Elemental MediaStore.
//
// Creates an access policy for the specified container to restrict the users
// and clients that can access it. For information about the data that is included
// in an access policy, see the AWS Identity and Access Management User Guide
// (https://aws.amazon.com/documentation/iam/).
//
// For this release of the REST API, you can create only one policy for a container.
// If you enter PutContainerPolicy twice, the second command modifies the existing
// policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaStore's
// API operation PutContainerPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeContainerNotFoundException "ContainerNotFoundException"
//   Could not perform an operation on a container that does not exist.
//
//   * ErrCodeContainerInUseException "ContainerInUseException"
//   Resource already exists or is being updated.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   The service is temporarily unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicy
func (c *MediaStore) PutContainerPolicy(input *PutContainerPolicyInput) (*PutContainerPolicyOutput, error) {
	req, out := c.PutContainerPolicyRequest(input)
	return out, req.Send()
}

// PutContainerPolicyWithContext is the same as PutContainerPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutContainerPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaStore) PutContainerPolicyWithContext(ctx aws.Context, input *PutContainerPolicyInput, opts ...request.Option) (*PutContainerPolicyOutput, error) {
	req, out := c.PutContainerPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This section describes operations that you can perform on an AWS Elemental
// MediaStore container.
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/Container
type Container struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the container. The ARN has the following
	// format:
	//
	// arn:aws:<region>:<account that owns this container>:container/<name of container>
	//
	// For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
	ARN *string `min:"1" type:"string"`

	// Unix timestamp.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The DNS endpoint of the container. Use from 1 to 255 characters. Use this
	// endpoint to identify this container when sending requests to the data plane.
	Endpoint *string `min:"1" type:"string"`

	// The name of the container.
	Name *string `min:"1" type:"string"`

	// The status of container creation or deletion. The status is one of the following:
	// CREATING, ACTIVE, or DELETING. While the service is creating the container,
	// the status is CREATING. When the endpoint is available, the status changes
	// to ACTIVE.
	Status *string `min:"1" type:"string" enum:"ContainerStatus"`
}

// String returns the string representation
func (s Container) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Container) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Container) SetARN(v string) *Container {
	s.ARN = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Container) SetCreationTime(v time.Time) *Container {
	s.CreationTime = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Container) SetEndpoint(v string) *Container {
	s.Endpoint = &v
	return s
}

// SetName sets the Name field's value.
func (s *Container) SetName(v string) *Container {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Container) SetStatus(v string) *Container {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainerInput
type CreateContainerInput struct {
	_ struct{} `type:"structure"`

	// The name for the container. The name must be from 1 to 255 characters. Container
	// names must be unique to your AWS account within a specific region. As an
	// example, you could create a container named movies in every region, as long
	// as you don’t have an existing container with that name.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateContainerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContainerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContainerInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *CreateContainerInput) SetContainerName(v string) *CreateContainerInput {
	s.ContainerName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainerOutput
type CreateContainerOutput struct {
	_ struct{} `type:"structure"`

	// ContainerARN: The Amazon Resource Name (ARN) of the newly created container.
	// The ARN has the following format: arn:aws:<region>:<account that owns this
	// container>:container/<name of container>. For example: arn:aws:mediastore:us-west-2:111122223333:container/movies
	//
	// ContainerName: The container name as specified in the request.
	//
	// CreationTime: Unix timestamp.
	//
	// Status: The status of container creation or deletion. The status is one of
	// the following: CREATING, ACTIVE, or DELETING. While the service is creating
	// the container, the status is CREATING. When an endpoint is available, the
	// status changes to ACTIVE.
	//
	// The return value does not include the container's endpoint. To make downstream
	// requests, you must obtain this value by using DescribeContainer or ListContainers.
	//
	// Container is a required field
	Container *Container `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateContainerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateContainerOutput) GoString() string {
	return s.String()
}

// SetContainer sets the Container field's value.
func (s *CreateContainerOutput) SetContainer(v *Container) *CreateContainerOutput {
	s.Container = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerInput
type DeleteContainerInput struct {
	_ struct{} `type:"structure"`

	// The name of the container to delete.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteContainerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContainerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContainerInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DeleteContainerInput) SetContainerName(v string) *DeleteContainerInput {
	s.ContainerName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerOutput
type DeleteContainerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteContainerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicyInput
type DeleteContainerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that holds the policy.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteContainerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContainerPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContainerPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DeleteContainerPolicyInput) SetContainerName(v string) *DeleteContainerPolicyInput {
	s.ContainerName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicyOutput
type DeleteContainerPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteContainerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteContainerPolicyOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainerInput
type DescribeContainerInput struct {
	_ struct{} `type:"structure"`

	// The name of the container to query.
	ContainerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeContainerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContainerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContainerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContainerInput"}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *DescribeContainerInput) SetContainerName(v string) *DescribeContainerInput {
	s.ContainerName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainerOutput
type DescribeContainerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the queried container.
	Container *Container `type:"structure"`
}

// String returns the string representation
func (s DescribeContainerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContainerOutput) GoString() string {
	return s.String()
}

// SetContainer sets the Container field's value.
func (s *DescribeContainerOutput) SetContainer(v *Container) *DescribeContainerOutput {
	s.Container = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicyInput
type GetContainerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetContainerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContainerPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContainerPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContainerPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *GetContainerPolicyInput) SetContainerName(v string) *GetContainerPolicyInput {
	s.ContainerName = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicyOutput
type GetContainerPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the access policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetContainerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContainerPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetContainerPolicyOutput) SetPolicy(v string) *GetContainerPolicyOutput {
	s.Policy = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainersInput
type ListContainersInput struct {
	_ struct{} `type:"structure"`

	// Enter the maximum number of containers in the response. Use from 1 to 255
	// characters.
	MaxResults *int64 `min:"1" type:"integer"`

	// Only if you used MaxResults in the first command, enter the token (which
	// was included in the previous response) to obtain the next set of containers.
	// This token is included in a response only if there actually are more containers
	// to list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListContainersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContainersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContainersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContainersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContainersInput) SetMaxResults(v int64) *ListContainersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainersInput) SetNextToken(v string) *ListContainersInput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainersOutput
type ListContainersOutput struct {
	_ struct{} `type:"structure"`

	// The names of the containers.
	//
	// Containers is a required field
	Containers []*Container `type:"list" required:"true"`

	// NextToken is the token to use in the next call to ListContainers. This token
	// is returned only if you included the MaxResults tag in the original command,
	// and only if there are still containers to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListContainersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContainersOutput) GoString() string {
	return s.String()
}

// SetContainers sets the Containers field's value.
func (s *ListContainersOutput) SetContainers(v []*Container) *ListContainersOutput {
	s.Containers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContainersOutput) SetNextToken(v string) *ListContainersOutput {
	s.NextToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicyInput
type PutContainerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// The contents of the policy, which includes the following:
	//
	//    * One Version tag
	//
	//    * One Statement tag that contains the standard tags for the policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutContainerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutContainerPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutContainerPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutContainerPolicyInput"}
	if s.ContainerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerName", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerName sets the ContainerName field's value.
func (s *PutContainerPolicyInput) SetContainerName(v string) *PutContainerPolicyInput {
	s.ContainerName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutContainerPolicyInput) SetPolicy(v string) *PutContainerPolicyInput {
	s.Policy = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicyOutput
type PutContainerPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutContainerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutContainerPolicyOutput) GoString() string {
	return s.String()
}

const (
	// ContainerStatusActive is a ContainerStatus enum value
	ContainerStatusActive = "ACTIVE"

	// ContainerStatusCreating is a ContainerStatus enum value
	ContainerStatusCreating = "CREATING"

	// ContainerStatusDeleting is a ContainerStatus enum value
	ContainerStatusDeleting = "DELETING"
)
