[Documentation Home](docs) | [Wiki Page](https://wiki.twitch.com/display/QE/Cross+Browser+Test+Infrastructure) | [Contact](https://wiki.twitch.com/display/QE/Cross+Browser+Test+Infrastructure#CrossBrowserTestInfrastructure-ContactUs)

- - -

Grid is a Cross Browser Infrastructure that allows you to run your Selenium tests across various Operating Systems and Browsers.

Refer to the [Cross Browser Test Infrastructure Wiki](https://wiki.twitch.com/display/QE/Cross+Browser+Test+Infrastructure)
for more information on supported platforms and onboarding info.

## Folder Structure
This repository is structured based on type (Hub/Node), and within nodes, separated by platform.

Most Terraform, Build, and Provisioning systems exist within its folder.

View the [src](src) folder to see the structure.

### Platforms
Here are some quick links for the platforms:
- [Windows](src/node/windows)
- [Linux](src/node/linux)
- [MacOS](src/node/macos)
- [Hub](src/hub)

Code shared across all:
- [Shared](src/shared)

## Developing for Grid
Pull requests are welcome. Our roadmap can be found on the above linked wiki.

We've separated documentation by platform. Please refer to the above platform links to find specific information.

## Extending Selenium Grid
We have defined extensions for Selenium Grid. Nodes do not use vanilla Selenium Grid.

For details, see
[Selenium Extensions Readme](src/shared/selenium/extensions/README.md)

## Additional Documentation
As mentioned above, see each platform for specific docs.

Higher level docs can be found in the [docs](docs) folder.

## Related Repositories
- [App Launcher](https://git.xarth.tv/qe/app_launcher)
- [Screen Resolution CLI](https://git.xarth.tv/qe/screen_resolution_cli)
- [CBGModules](https://git.xarth.tv/qe/CBGModules)
