# Instance Lifecycle
This documentation serves to discuss spinning instances up & shutting instances down.

## Capacity
We host one machine for every potential concurrent session.
Each team is given a number of concurrent machines, which is tracked here.

Currently no preventions are in place for teams to use more than the allotted amount.
In doing so, they may interfere with other teams.

You can see each teams allotted amount at: [Onboarded Teams](https://wiki.twitch.com/display/QE/Onboarded+Teams).

## Spinning Up Instances
Instances are automatically provisioned. When you start a machine, it should be ready within about 20 minutes.

New instances are added to AWS via Terraform. Refer to the terraform section of the node type you're using.

_Note: Win8 is partially in terraform (3 instances). The rest were created manually._

Once you increase the number count, plan, and apply, the instances will launch in AWS.

You can then refer to [Logging Documentation](logging_and_metrics.md) to see how to track instances.

### High Disk Utilization
When instances spin up, they currently have high disk utilization for 30 or so minutes.

It's recommended you set Auto Launch Grid to false, let the Disk IO drop (while looking at Grafana),
and then change Auto Launch to true and restart the instance.

## Shutdown
Shutdown is an extremely fragile process.
This is because the node is connected to Grid, and during shutdown it may terminate an in-progress test.

Currently there is no way to stop inbound requests, and then shutdown. This feature can be tracked in [QE-1509](https://jira.twitch.com/browse/QE-1509).

To shutdown, I recommend you check Grid Console for active sessions, and only shut down instances if none are in session.
A good way to check is to open your Developer Tools and search for the class `.busy` - if it appears more than once, a session is in progress.

Alternatively you can check which IPs have a session in progress and avoid shutting those down.
