job {
  name 'browser-grid-win10-deploy'
  description('Deploys branches for a Browser Grid Cluster')
  concurrentBuild(true)

  parameters {
    stringParam('GRID_CLUSTER_ID', '', 'The cluster id to deploy to')
    choiceParam('GRID_ENVIRONMENT', ['dev', 'prod'], 'The environment')
    choiceParam('GRID_HUB_ENVIRONMENT', ['dev', 'dev-ato', 'prod', 'prod-2xl', 'prod-cdp'], 'The hub environment')
    stringParam('GRID_BRANCH', '', 'The branch to deploy')
    stringParam('AWS_DEFAULT_REGION', 'us-west-2', 'The AWS Region')
    choiceParam('DEPLOY_TYPE', ['replace', 'chef'], 'The type of deploy. Replace will fully replace instances. Chef will run updated chef.')
  }

  scm {
    git {
      remote {
        github 'qe/grid', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
      branch 'origin/master'
    }
  }

  logRotator {
    daysToKeep(90)
  }

  wrappers {
    colorizeOutput(colorMap = 'xterm')
    timestamps()
  }

  steps {
    shell """
      |./scripts/ci/deploy/run_in_ci.sh
    """.stripMargin()
  }
}

job {
  name 'browser-grid-win10-modify-instance-type'
  description('Modifies a Cluster\'s Instance Type')

  parameters {
    stringParam('GRID_CLUSTER_ID', '', 'The cluster id to modify')
    choiceParam('GRID_ENVIRONMENT', ['dev', 'prod'], 'The environment')
    choiceParam('GRID_HUB_ENVIRONMENT', ['dev', 'dev-ato', 'prod', 'prod-2xl', 'prod-cdp'], 'The hub environment')
    stringParam('GRID_TARGET_INSTANCE_TYPE', 'c4.xlarge', 'The target instance type to move the instances to')
    stringParam('AWS_DEFAULT_REGION', 'us-west-2', 'The AWS Region')
  }

  scm {
    git {
      remote {
        github 'qe/grid', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
      branch 'origin/master'
    }
  }

  logRotator {
    daysToKeep(90)
  }

  wrappers {
    colorizeOutput(colorMap = 'xterm')
    timestamps()
  }

  steps {
    shell """
      |DEPLOY_TYPE=modify_instance_type ./scripts/ci/deploy/run_in_ci.sh
    """.stripMargin()

    // While node boots, it takes some time to load Windows. Sleep for a bit while awaiting Windows
    shell """
    echo 'Giving Nodes chance to finish boot process'
    sleep 90
    """
  }
}
