# Deploy

Deploys a new branch to Windows 10 Nodes.

This will cause all nodes in the specified ASG to be terminated, so be warned!!

It was written in Ruby, as I wanted this to have some safeguards since it's terminating instances.
It was challenging to write in Go due to GOPATH constraints

## Usage

The docker container will run any Ruby Script passed to it. You do this via:
```docker run image_name ruby deploy.rb```

Must provide environment variables:
- GRID_CLUSTER_ID: The cluster id to update (i.e., `c0msd79p`)
- GRID_ENVIRONMENT: The environment (dev/prod)
- GRID_BRANCH: The branch to update to (if you provide no new branch, nodes will still be replaced)

You can also either mount your AWS Credentials Folder to the Docker Container, or pass credentials via ENV Variables:
- AWS_ACCESS_KEY_ID
- AWS_SECRET_ACCESS_KEY
- AWS_DEFAULT_REGION

To mount: `-v "~/.aws/credentials:/root/.aws/credentials:ro"`

Example:
```
docker build -t grid-node-deploy . \
  && docker run \
    -v "\$PWD":/usr/src/myapp \
    -w /usr/src/myapp \
    -v "~/.aws/credentials:/root/.aws/credentials:ro" \
    -e GRID_CLUSTER_ID="c0msd79p" \
    -e GRID_ENVIRONMENT="dev"
    -e GRID_BRANCH="master" \
    -e AWS_DEFAULT_REGION="us-west-2" \
    --rm grid-node-deploy ruby deploy.rb
```
