#!/bin/bash

# Launches an RDP Session into a Windows Node
# Usage: ./rdp_node.sh i-MyInstanceID

# RDP Documentation:
# https://docs.microsoft.com/en-us/windows-server/remote/remote-desktop-services/clients/rdp-files
# https://docs.microsoft.com/en-us/windows-server/remote/remote-desktop-services/clients/remote-desktop-uri
# Password via CLI unfortunately not currently supported

set -e # Exit on first error

# Grab the Instance ID from the first argument
instanceID="$1"

main() {
  if [ -z "$instanceID" ]; then
        >&2 echo "Must provide instance id. Example: $0 i-12345"
        exit 1
  fi

  profile=$(getAccountNameOfInstance)
  echo "Using Profile: $profile"

  # Store path of this script so paths can be made towards it
  parentPath=$( cd "$(dirname "${BASH_SOURCE[0]}")" ; pwd -P )

  # Async Launch the RDP Client after sleeping to allow connection to be established
  sleep 5 && open "$parentPath/localhost.rdp" &

  # Start the SSM Session on port 3389 (RDP)
  aws ssm start-session --profile "${profile}" \
    --target "$instanceID" --document-name AWS-StartPortForwardingSession \
    --parameters '{"portNumber":["3389"],"localPortNumber":["3389"]}' &

  # WORKAROUND - stop session-manager-plugin on Ctrl + C. See https://github.com/aws/aws-cli/issues/5149
  AWS_SSM_PID=$!
  sleep 2
  SESSION_MANAGER_PLUGIN_PID=$(ps o pid,ppid,command | grep "^[0-9]* $AWS_SSM_PID session-manager-plugin" | cut -d ' ' -f1)
  trap 'exit_code=$?; kill $SESSION_MANAGER_PLUGIN_PID; exit $exit_code' INT TERM EXIT
  wait $AWS_SSM_PID
  # WORKAROUND END
}

# Returns the name of the account that holds a given instance that was passed to the script
getAccountNameOfInstance() {
  # Grab all Grid AWS Accounts
  getAccountManifest

  # Loop through each account in the manifest
  # Search for the instance in that account
  while read i; do
    local accountName="$i"

    # Search the account for Instance ID
    result=$(aws ec2 describe-instances --profile "$accountName" --instance-ids "$instanceID" 2>/dev/null)
    # Make sure the command result was successful - if it doesn't exist, cli will return a non-0 exit code
    if [ "$?" -ne 0 ]; then
      continue
    fi

    # Ensure 1 instance was returned
    local resultCount=$(echo "$result" | jq '.[] | length')
    if [ "$resultCount" -eq 1 ]; then
      echo "$accountName"
      rm accounts.json # clean up
      exit 0
    fi
  done < <(jq -r -c '.[].name' accounts.json)

  rm accounts.json # clean up
  >&2 echo "Instance ID could not be found in any of the accounts"
  exit 1
}

# Fetch the manifest of the account numbers for Browser Grid
# Downloads it to a file called accounts.json
getAccountManifest() {
  aws s3 cp --profile "twitch-browsergrid-prod" --quiet s3://grid-artifacts/accounts.json accounts.json
  local result="$?"

  if [ "$result" -ne 0 ]; then
    >&2 echo "Error downloading account manifest"
    exit 1
  fi
}

main
