#!/bin/bash
# Launches an SSH Port Forwarding Session with a Kibana Proxy and opens Chrome

PEM_FILE="$HOME/Documents/pems/kibana_proxy.pem"
ES_ENDPOINT="search-browsergrid-central-logging-y4s4stlohnc6ngq7l4xnnsq6um.us-west-2.es.amazonaws.com:443"

if [ -z "$AWS_PROFILE" ]; then
  echo "ENV Var AWS_PROFILE not provided. Using default twitch-browsergrid-prod"
  export AWS_PROFILE="twitch-browsergrid-prod"
fi

if [ ! -f "$PEM_FILE" ]; then
    # TODO: Don't be lazy and allow user to provide their PEM File location :) being lazy as this solution is probably temporary
    echo "Please store the kibana_proxy.pem at this location: $PEM_FILE"
    exit 1
fi

# Fetch EC2 Instance
INSTANCE_NAME="kibana-proxy"
INSTANCE_ID=$(aws ec2 describe-instances --filters Name=tag:Name,Values=$INSTANCE_NAME Name=instance-state-name,Values=running --query "Reservations[0].Instances[0].InstanceId" --output text)

if [ -z "$INSTANCE_ID" ] || [ "$INSTANCE_ID" = "None" ]; then
  echo "Error finding Instance ID. Ensure you're supplying the proper AWS_PROFILE env variable"
  exit 1
fi

# Launch Chrome & The Reverse Proxy
echo "Launching the reverse proxy. When finished, Ctrl+D"
sleep 4 && /Applications/Google\ Chrome.app/Contents/MacOS/Google\ Chrome --allow-insecure-localhost https://localhost:3000/_plugin/kibana &
ssh -i "$PEM_FILE" -L 3000:"$ES_ENDPOINT" ec2-user@"$INSTANCE_ID"
