#!/bin/bash
# This script will build the Firefox Node Container

# Note, Upgrading Selenium Version requires changing TAG as well as image_name
TAG=3.11.0-californium
FF_VERSION=47.0.1
image_name="docker.pkgs.xarth.tv/qe/cbg-node-firefox:3.11.0"

set -e # Stop immediately on error

# Need to build the original image with a custom firefox version
# Pull the repo and build it
git clone git@github.com:SeleniumHQ/docker-selenium.git
cd docker-selenium
git fetch && git fetch --tags
git checkout $TAG
BUILD_ARGS="--build-arg FIREFOX_VERSION=$FF_VERSION" make firefox

cd ..

# Builds docker image, pushes to docker registry
echo "Building Docker Image"
docker build --build-arg BASE_VERSION=$TAG -t $image_name .

# Clean Up
rm -rf docker-selenium

echo "Pushing to Registry - $image_name"
docker push $image_name
docker rmi $image_name
