# macOS

Mac Mini located in QA Lab:
192.168.7.88

## Provisioning

macOS is currently manually provisioned. Here are some notes on the steps to take:

1) Install macOS High Sierra
2) Create a `qualityengineering` account, separate from the selenium account
3) Create a "selenium" account with administrator privileges (needed for controlling Safari)
4) Go to Login Options and enable Automatic Login for Selenium User
5) Log in as selenium user
4) Go to Settings -> Sharing and enable Remote Login and Screen Share for only the selenium account
5) Disable Wifi
5) Download and install [JDK 8](http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html)
6) Pin terminal to dock
7) Create a directory path `/Library/grid`
8) Download [Selenium Standalone](http://selenium-release.storage.googleapis.com/index.html) and place in `/Library/grid`
9) Copy over start_grid.sh and nodeConfig.sh into the grid folder
10) Run `safaridriver --enable`
11) Disable turning off display from Energy Preferences (this seems to break safari usage)

### Hostname
For easy identification of hardware, the hostname should be set to:
`qe-grid-mac-*`

Replacing * with the node number. This is used in things like reporting to statsd.

Example:
```
sudo scutil --set HostName qe-grid-mac-1
sudo scutil --set LocalHostName `hostname`
sudo scutil --set ComputerName `hostname`
dscacheutil -flushcache
shutdown -r now
```

### Login Tasks
macOS Supports Login / Startup Tasks. This can be used to launch Grid on boot.

launch.scrpt is an AppleScript file that defines startup tasks.
It should be opened with ScriptEditor, and exported as a .app file in `/Library/grid`

You can then add that .app as a login item.

Go to Users & Groups, selenium, and then Login Items. Add `/Library/grid/launch.app`

### Display Resolution
When macOS boots without a display attached to it (headless), it has a small resolution associated with it.

There doesn't appear to be a CLI available for setting this on boot, so we'll have to build something. See https://jira.twitch.com/browse/QE-1642

In the meantime, after boot, go to `Applications/Display Menu` (downloaded from macOS Store) and set to 1920 x 1080

## Launching Grid from Machine
Open terminal and run `./Library/grid/start_grid.sh`

## Accessing Machine
The machine is accessible from SSH and Screen Share.

### SSH
`ssh selenium@IP_OF_MACHINE`

### Screen Share
Open Safari, go to `vnc://IP_OF_MACHINE`
