#!/bin/bash

CONFIG_DIRECTORY=/Library/grid
PROD_URL="http://grid.us-west2.justin.tv:80"
DEV_URL="http://grid-dev.us-west2.justin.tv:80"

# Get command line arguments
while getopts ":e:" opt; do
  case ${opt} in
    e ) # process option e
    host_environment=$OPTARG # Set the e option argument to $host_environment
      ;;
    \? ) echo "Usage: $0 [-e] environment"
         exit 1
      ;;
  esac
done

# Determine the Hub URL

hub_url="" # Initialize variable to blank

shopt -s nocasematch # Enable Case insensitive Matching
# If the Grid URL is Set and its argument is "prod"
if [[ -n "$host_environment" && "${host_environment}" == "prod" ]]; then
  hub_url=$PROD_URL # Connect to production
else
  hub_url=$DEV_URL # Connect to dev
fi
shopt -u nocasematch # Disable case insensitive matching

# Launch Grid

echo "Launching Grid Node, Connecting to: $hub_url"
java -jar "$CONFIG_DIRECTORY/selenium-server-standalone-3.11.0.jar" \
  -role node \
  -nodeConfig "$CONFIG_DIRECTORY/nodeConfig.json" \
  -hub "$hub_url"
