# Windows 10 Node Platform

This documentation is specific around the Windows 10 Node Platform.

Windows 10 is automatically provisioned through PowerShell, and its infrastructure is managed through terraform.

## Configuration

Grid configuration and provisioning consists of mostly Powershell and C#.
Terraform is used to manage the AWS Infrastructure.

From a high level, the following makes Grid:
1) A base image of the operating system is created (see [Base Image](docs/base_image.md)).
2) The base image is uploaded to Amazon S3 to be converted to an AMI
3) Instances are created in the terraform folder.
4) [Provisioning](#provisioning) is ran within "UserData", which will check what git branch to pull data from, and download the provision script
5) The provision script downloads the necessary items, makes some security changes, and then registers a script to run at startup
6) On startup, the screen resolution is set, and then the grid binary is started

### Hub Connection Logic
It's necessary for the nodes to have a hub to connect to.

There are two different types of nodes:
1) Regular (c4.xlarge)
2) 2xl (c4.2xlarge)

2xl nodes are higher spec'd machines, used for performance testing.

A tag, defined as `HubFQDN`, will have a value consisting of the FQDN of the hub it should connect to.
Regular nodes will connect to a different hub from the 2xl nodes.

The node's `HubFQDN` tag is defined within the Terraform file.

The node then knows how to connect to that within [launch.ps1](resources/launch.ps1), by pulling the value of the tag.

## Making Updates

### Provisioning
This section describes managing the software and configuration that's running on an AWS Instance.

All provisioning files can be found in [Resources][resources].

#### Flow
The entry point file that runs at the start of a new AWS Instance is [get_provision.ps1][get_provision.ps1].
Edits to this should be avoided if possible. That file is responsible for downloading the provisioning files for that branch.
Any edit to this file will require instances to tear down and come back up, causing a full grid outage.

[provision.ps1][provision.ps1] is the file you will want to make updates to if applicable.
This is the first file ran after get_provision.

It's recommended if you're added a new application or configuration, to create a new .ps1 file within [resources][resources].
You can then call that file within [provision.ps1][provision.ps1].

#### Example
Let's say you want to run a script that adds a file called hello_world.txt to the desktop.

1) Add a file in the [Resources][resources] folder called `hello_world.ps1`
2) Within hello_world.ps1, add:
```
# A comment for what this script does.
# This is an example that adds a hello_world.txt file to the desktop of the Selenium user.
New-Item -Path C:\Users\selenium\Desktop\hello_world.txt -Type File
```

3) Then, within [provision.ps1][provision.ps1], add a line to call the hello_world script:
```
& C:\ProgramData\grid_config\hello_world.ps1
```

### Terraform
Adding or removing instances is done within terraform.

You can see the configuration in the [terraform](terraform) folder.
Refer to the [Terraform Readme](terraform/README.md) for more detail.

## Exporting Changes: Build System
We utilize [Manta](.manta.json) and [Jenkins](../../../../jenkins.groovy) for our builds.

When you push up a branch, all files within the [resources][resources] folder are zipped up to S3.

[get_provision.ps1][get_provision.ps1] will then download and unzip the resources folder to `C:\ProgramData\grid-config`.

Jenkins will zip all of the powershell script artifacts from the [resources][resources] folder and upload it to our "grid-artifacts" S3 bucket.
It creates a folder consisting of the git branch name.

In the terraform configuration, you can then specify the git branch name, and those artifacts will be downloaded.

## Logging
There are various logging methods utilized for Windows 10 nodes.

### Central Syslog
We send logs to Central Syslog. These include:
1) Provisioning Status (when machine is first brought online)
2) Selenium INFO Logs (utilizing CBG Extensions JAR)
3) Selenium stdout/stderr (utilizing a powershell job to collect selenium logs)

For details on central syslog logging, see [logging_and_metrics.md](../../../../docs/logging_and_metrics.md)

For details on how this is done, see [Selenium Extensions Readme](../../../shared/selenium/extensions/README.md)

### Security System Events Logs
We upload System Event logs used by security to Cloudwatch Logs.

The namespace is:
`/aws/ec2/grid/win10/*`

### Local File
For TRACE/DEBUG logs (more detailed), we store these locally on the computer and rotate them.

This is configured by the [start_grid.cmd](resources/start_grid.cmd) and the [logging config](resources/selenium_logging.config)
by utilizing the File Handler.

You can find the logs at C:\ProgramData\grid-config\cbg-bin and look for the log.txt files.

They are currently capped at 5GB's, logging 500MBs at a time (for a total of 10 files).

[resources]: resources
[get_provision.ps1]: ../../../shared/terraform/hub_node_cluster/module/windows_10/get_provision.ps1
[provision.ps1]: resources/provision.ps1
