**Important: This is incomplete, pending Windows Updates**

This should be considered in debug mode, as win10.json doesn't actually create an exported image. Tickets to track:
- https://jira.twitch.com/browse/QE-1354
- https://jira.twitch.com/browse/QE-1355

# Base Image Build

This folder is responsible for building Base Images. It currently only supports Windows 10.

Building new Base Images is great for pre-installing Windows Updates, as well as software necessary on all machines.
They should be lite, and other provisioning scripts should do the specific installation.

### Pre-Reqs
##### Packer
To build a new image, we use Packer. Install it via [Homebrew](https://brew.sh/)
```
brew install packer
```

##### VirtualBox
Next, [Install VirtualBox](https://www.virtualbox.org/wiki/Downloads), which Packer uses to assist with building.

### Building An Image
To build a new image, we use Packer.

First, download the Enterprise ISO provided by IT. It's currently in the Windows dropbox shared folder.

Move the Enterprise ISO (given by IT) into the images folder.

Update the sha1 of the image (if necessary) within win10.json. Example:
```
shasum images/SW_DVD5_Win_Pro_Ent_Edu_N_10_1803_64BIT_English_-2_MLF_X21-79647.ISO 
```

Then, run this command:
```
./build.sh
```

Everything should be automated at this point.

### Behind the Scenes
There are various processes that take place when building an image.

Most of these are defined either in the [Autounattend.bak.xml](Autounattend.bak.xml) file, or within the Provision section of [win10.json](win10.json).

1) ISO Image of the Windows 10 machine is pulled, either locally or from S3.
2) Autounattend file installs Windows. [Details below](#autounattend-file).
3) Selenium user account is added
4) [shutdown.ps1](scripts/shutdown.ps1) disables the vagrant account that Packer used to build, and shuts down the machine.

### Licensing
We utilize IT's KMS Server for licensing Windows 10 Enterprise.

This is automatically configured within Packer, but the manual steps are listed below if needed.

The product key that should be used in installation is listed at
[https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2012-R2-and-2012/jj612867(v=ws.11)](Appendix A: KMS Client Setup Keys)
under `Windows 10 Enterprise`

Then, to license, within Powershell run
```
C:\Windows\System32\slmgr.vbs /skms kms.corp.xarth.tv:1688; C:\Windows\System32\slmgr.vbs /ato
```

You can then verify the machine is licensed, running:
`cscript slmgr.vbs /dlv`

### Autounattend File
The Autounattend file includes things like setting the region, network, and WinRM so that packer can run scripts.
Without it, Windows would not be installed on the image.

The Autounattend file was created using [Windows System Image Manager]().

From there, you can drag the necessary sections in order to build the XML file.

You may need to add the version of Windows 10 so that the file can be built.
1) Open the ISO to view the files (macOS Disk Image Mounter will work, the default program - just double click)
2) Go to Sources
3) Copy `INSTALL.wim` to your drive
4) From Systems Image Manager, click Select a Windows Image and open the `INSTALL.wim`
5) Select Windows 10 Enterprise
6) Click Yes to create the catalog file
7) Click New Answer File

You should use the existing Autounattend.xml file as a template for the necessary sections.

Helpful Video: https://www.youtube.com/watch?v=kzklC85c3ZQ
