#!/usr/bin/env bash

SETUP_FILE='Autounattend.xml' # Where to store the password file
SYSPREP_FILE='sysprep2008.xml'

# Exits with an error message. Cleans up password file as well
# @param $1 - A string with the failure message
exit_with_error()
{
  MSG="$1"
  rm $SETUP_FILE
  printf "$MSG"
  exit 1
}

# Grab the Password from Sandstorm. Use AWS_SDK_LOAD_CONFIG to allow Isengard credentials
user_password=$(AWS_PROFILE=twitch-cape-qe-aws AWS_SDK_LOAD_CONFIG=1 sandstorm get -n --role-arn "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/qe-prod-grid" qa-eng/grid/production/windows-10-password)

# Check the exit codes of the above command, make sure it was success
result=$?
case $result in
 127)
 # Was Not Installed
 exit_with_error "\n\nERROR! You don't have Sandstorm installed. Please install it via these instructions:\nhttps://wiki.twitch.com/display/SSE/Sandstorm+CLI\n"
 ;;
 0)
 # Do nothing, 0 means success
 ;;
 *)
 # Default statement, something unknown
 exit_with_error "\n\nERROR! Unexpected error code: $result\n"
 ;;
esac

# Create an Autounattend.xml file with all references of "REPLACE_PASSWORD" to be the password grabbed from Sandstorm
sed "s/REPLACE_PASSWORD/$user_password/" Autounattend.bak.xml > $SETUP_FILE
sed "s/REPLACE_PASSWORD/$user_password/" sysprep2008.bak.xml > $SYSPREP_FILE

# Call Packer to build the image
packer build -force -var "user_password=$user_password" -on-error=ask win10.json

# Clean Up
rm $SETUP_FILE
rm $SYSPREP_FILE
