# Disables/Uninstalls any addon apps that are not necessary

function Main() {
    Uninstall-OneDrive
}

function Uninstall-OneDrive() {
    # Find any existing processes

    try
    {
        $proc = Get-Process -Name "OneDrive"
        Stop-Process -InputObject $proc
        $hasExited = $(Get-Process | Where-Object {$_.HasExited})

        if($hasExited.length -gt 0 -and $hasExited.ProcessName -ne "OneDrive") {
            echo "There was a problem stopping the OneDrive proces"
        }
        elseif ($hasExited.length -le 0)
        {
            echo "There were no processes that recently exited"
        }
    }
    catch
    {
        echo "OneDrive may not have been running. Ignoring & moving onto uninstall step..."
    }

    # Uninstall
    echo "Uninstalling OneDrive"
    $proc = Start-Process -FilePath "$env:SystemRoot\SysWOW64\OneDriveSetup.exe" -ArgumentList "/uninstall" -Wait -PassThru
    $proc.waitForExit()
    echo "OneDrive Uninstallation Completed with Exit Code: $($proc.ExitCode)"
}

# Run the main program
Main
