# This script will clean out the disk, including previous windows update versions and the temp folder
# Need to set a registry value to tell cleanmgr what to delete, via the sagerun argument
# https://winaero.com/blog/cleanmgr-exe-command-line-arguments-in-windows-10/#SAGERUN

$strKeyPath   = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\VolumeCaches"
$strValueName = "StateFlags0065"
$subkeys      = Get-ChildItem -Path $strKeyPath -Name

# Set Registry Keys
ForEach($subkey in $subkeys){
    $null = New-ItemProperty `
        -Path $strKeyPath\$subkey `
        -Name $strValueName `
        -PropertyType DWord `
        -Value 2 `
        -ea SilentlyContinue `
        -wa SilentlyContinue
}

# Clean up files
echo "Running Disk Cleanup. This may take a long time."
Start-Process cleanmgr `
        -ArgumentList "/sagerun:65" `
        -Wait `
        -NoNewWindow `
        -ErrorAction   SilentlyContinue `
        -WarningAction SilentlyContinue
echo "Disk Cleanup Complete"

# Remove registry keys
ForEach($subkey in $subkeys){
    $null = Remove-ItemProperty `
        -Path $strKeyPath\$subkey `
        -Name $strValueName `
        -ea SilentlyContinue `
        -wa SilentlyContinue
}

exit 0
