# Downloads and Installs AWS Powershell

function Main() {
    $path = Download
    Install($path)
    Remove-Item -Path $path # cleanup
}

# Downloads AWS Tools
# @return [String] The path to the folder where the installer was saved
function Download() {
    $url = "https://sdk-for-net.amazonwebservices.com/latest/AWSToolsAndSDKForNet.msi"
    $path = "$($env:TEMP)\AWSToolsAndSDKForNet.msi"

    # Download
    Write-Host "Downloading AWS Tools for PowerShell from $url to $path"
    (New-Object System.Net.WebClient).DownloadFile($url, $path)

    # Make sure the file exists
    if (!(Test-Path $path))
    {
        throw "After download, could not find path $path"
    }
    return $path
}

# Installs AWS Tools from the path provided
# @param [String] path The path to where installations exist
function Install($path) {
    $arguments = "/i $path /passive"
    Write-Host "Installing AWS Tools for PowerShell"

    # Start Install
    $proc = Start-Process msiexec.exe -PassThru -Wait -NoNewWindow -ArgumentList $arguments
    # Make sure install was successful
    if ($proc.ExitCode -ne 0)
    {
        throw "AWS Tools for Powershell Installation exited with unexpected code: $($proc.ExitCode)"
    }

    Write-Host "AWS Tools for Powershell Installed - exit code $($proc.ExitCode)"
}

Main
