# Installs Chef (including dependencies)
# Does NOT use Chef Omnibus Installers to comply with Licensing Requirements
# https://github.com/chef/chef/blob/master/docs/dev/how_to/building_and_installing.md#building-the-gem

$chefVersion = "16.5.64"

# Install dependencies to build chef
# Not locking to version as it's probably good to fetch the latest whenever we build a New AMI
choco install -y ruby  --version=2.7.2.1
choco install -y msys2 --version=20210105.0.0

# Refresh Path
$env:Path = [System.Environment]::GetEnvironmentVariable("Path","Machine") + ";" + [System.Environment]::GetEnvironmentVariable("Path","User")

# Install additional dependencies required to build chef
gem install bundler
ridk install 1 3

C:\tools\msys64\usr\bin\bash -lc 'pacman --noconfirm -Syuu'  # Normal update
C:\tools\msys64\usr\bin\bash -lc 'pacman --noconfirm -S mingw-w64-x86_64-libarchive'

# Fetch Chef & Build
gem install chef     -v "$chefVersion"
gem install chef-bin -v "$chefVersion"

# Confirm working
chef-client -v
