# Sets user permissions

function Main {
    # Allow selenium user to create files within Program Files. TODO: Get targetUser from config. QE-2209
    Allow-Permission -targetUsername "selenium" -targetPath "C:\Program Files" -permission "Write"
}

# This function will allow a File/Folder permission to a user
function Allow-Permission {
    param([string]$targetUsername, # The username to add this permission for
        [string]$targetPath, # The file / folder path to apply the permission to
        [string]$permission) # The permission to allow. Valid values: https://msdn.microsoft.com/en-us/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx

    $Acl = Get-Acl $targetPath # Get the current permissions

    # Create a filesystem access rule with the above parameters
    $Ar = New-Object  system.security.accesscontrol.filesystemaccessrule($targetUsername,$permission,"Allow")
    $Acl.SetAccessRule($Ar) # Set it on the current acl
    Set-Acl $targetPath $Acl # Attach the new acl back to the path
}

Main # Run the main function
