# This script is responsible for registering the Windows Update Job
# It'll register a job to run Windows Updates upon LogOn
# Errors will be logged to logfile

$logfile = "C:\Windows\Temp\register_job_log.txt"

try {
    $trigger = New-JobTrigger -AtLogOn # Set job to run upon login
    $option = New-ScheduledJobOption -StartIfOnBattery -ContinueIfGoingOnBattery -MultipleInstancePolicy IgnoreNew
    $job = Register-ScheduledJob -Trigger $trigger -Name "Windows Updates" -FilePath "a:\windows_updater.ps1" -ScheduledJobOption $option

    # Need to modify the task to specify the LogonType. Without this, the script wouldn't run at logon.
    # https://www.reddit.com/r/PowerShell/comments/4y7ig4/running_a_scheduled_job_at_logon/
    $taskPrincipal = New-ScheduledTaskPrincipal -LogonType Interactive -UserId $env:USERNAME -RunLevel Highest
    Set-ScheduledTask -TaskPath '\Microsoft\Windows\PowerShell\ScheduledJobs\' -TaskName $($job.Name) -Principal $taskPrincipal

    echo "Registered Job ID: $($job.id)"
    $job.Run()
} catch {
    $ErrorMessage = $_.Exception.Message
    $FailedItem = $_.Exception.ItemName
    "Exception found: Error Msg: $ErrorMessage    FailedItem: $FailedItem" | Out-File -Append -FilePath $logfile
}
