# This Script will run a WindowsUpdate C# Program, responsible for Searching, Downloading & Installing Windows Updates
# It will also deregister itself when the script returns exit code 2, indicating updates are complete

# Helpful article: https://blogs.technet.microsoft.com/stefan_gossner/2010/05/07/using-csharp-c-code-in-powershell-scripts/

# Required Assembly for Windows Update API
Add-Type -Path a:\Interop.WUApiLib.dll

# Include Assemblies
$Assem = (
"a:\\Interop.WUApiLib.dll"
)

# Load the source into Powershell
$Source = Get-Content -Raw -Path a:\WindowsUpdate.cs
Add-Type -ReferencedAssemblies $Assem -TypeDefinition $Source -Language CSharp

# Call the main
$result = [WindowsTools.WindowsUpdate]::Main()

# If script returned 2, indicating updates are complete
if ($result -eq 2)
{
    echo "Unregistering Scheduled Job"
    Disable-ScheduledJob -Name "Windows Updates"
    echo "Reenabling winrm"

    # Enable WinRM so that Packer can finish provisioning.
    # winRM is disabled so that packer will wait upon restarts for updates to install (bypassing packer)
    & a:\enableWinRM.ps1
}
