#!/bin/bash

# This will build Chef Artifacts into a consumable Chef Solo tarball
# It will then upload those artifacts to S3

set -e # exit when any command fails

REPOSITORY_URL="147030575244.dkr.ecr.us-west-2.amazonaws.com"
IMAGE_NAME="twitch_chef_builder"
IMAGE_VERSION="latest"
FULL_DOCKER_URL="$REPOSITORY_URL/$IMAGE_NAME:$IMAGE_VERSION"
S3_BUCKET="grid-artifacts"
chefArchiveName="chef_artifacts.zip" # The name of the tarball to upload to S3

SAVED_DIR=$(pwd) # Save directory so that we can go back if needed

aws ecr get-login-password --region us-west-2 | docker login --username AWS --password-stdin "$REPOSITORY_URL"
docker pull "$FULL_DOCKER_URL"

cd src/node/windows/10/chef/cookbooks/grid_node
docker run -v "$PWD:/build" "$FULL_DOCKER_URL"

cd extract
zip -r "$chefArchiveName" .

# If a GIT_BRANCH wasn't provided, exit early
if [ "$GIT_BRANCH" == "" ]
then
  echo "[ERROR] No git branch detected. Ensure the GIT_BRANCH env variable is passed."
  exit 1
fi

# GIT_BRANCH has origin/ in front of it, i.e., origin/master
# Use sed to remove the origin/ part and replace it with nothing
BRANCH_NAME=$(echo $GIT_BRANCH | sed -e "s/origin\///g")

# Construct an S3 URI based off the bucket and git branch
S3_URI="s3://$S3_BUCKET/git/$BRANCH_NAME/"

echo "Outputting chef artifacts into: $S3_URI/$chefArchiveName"
aws s3 cp --acl bucket-owner-full-control "$chefArchiveName" "$S3_URI"

rm "$chefArchiveName" # Clean up

cd "$SAVED_DIR" # Go back to original folder
