#!/usr/bin/env bash

# This script is used to upload build artifacts to S3
# The idea is to put each branches' artifacts into a separate folder
# Required environment variables: GIT_BRANCH, AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY

set -e # exit when any command fails

# Create the variables
S3_BUCKET="grid-artifacts"

# If a GIT_BRANCH wasn't provided, exit early
if [ "$GIT_BRANCH" == "" ]
then
  echo "[ERROR] No git branch detected. Ensure the GIT_BRANCH env variable is passed."
  exit 1
fi

# GIT_BRANCH has origin/ in front of it, i.e., origin/master
# Use sed to remove the origin/ part and replace it with nothing
BRANCH_NAME=$(echo $GIT_BRANCH | sed -e "s/origin\///g")

# Construct an S3 URI based off the bucket and git branch
S3_URI="s3://$S3_BUCKET/git/$BRANCH_NAME/"

# Zip the artifacts into a folder
# -j is for junk path, do not include the /build/resources path in the zipped folder
zip -r -j resources.zip src/node/windows/10/resources/

# Upload them to S3
echo "Outputting artifacts to folder: $S3_URI"
aws s3 cp --acl bucket-owner-full-control resources.zip "$S3_URI"
