# Launches the Selenium Grid binary
param(
  [string]$hubHost,
  [string]$seVersion
)

$ErrorActionPreference = "Stop" # Stop on any exception
$config_directory = "C:\ProgramData\grid-config"

# Make sure user provided a hub host
if ([string]::IsNullOrWhiteSpace($hubHost)) {
  $msg = "Must provide the hub's host. Example: cbg-hub.us-west2.justin.tv"
  Write-Log -level "ERROR" -message $msg
  throw $msg
}

# Make sure user provided required param
if ([string]::IsNullOrWhiteSpace($seVersion)) {
  $msg = "Must provide SeVersion as a parameter. Example: 4.0.0-beta-1"
  Write-Log -level "ERROR" -message $msg
  throw $msg
}

$arguments = `
  " -Dwebdriver.chrome.driver=$config_directory\chromedriver_win32\chromedriver.exe" `
  + " -jar $config_directory\selenium\selenium-server-$seVersion.jar" `
  + " node" `
  + " --publish-events tcp://$($hubHost):4442" `
  + " --subscribe-events tcp://$($hubHost):4443" `
  + " --grid-url http://$($hubHost)" `
  + " --config $config_directory\selenium\se4_config.toml"

# Friendly Output
echo "Starting Se Grid 4 against $hubHost, arguments: $arguments"
echo "Prompt will be held, output will be redirected"

# Start Process
Start-Process -FilePath "java.exe" `
  -ArgumentList $arguments `
  -NoNewWindow `
  -Wait
