# Returns the current installed firefox version
def firefox_version
  # Use the Windows Registry to fetch the current version
  path = 'SOFTWARE\Mozilla\Mozilla Firefox'
  key = 'CurrentVersion'
  begin
    reg = Win32::Registry::HKEY_LOCAL_MACHINE.open(path)
  rescue Win32::Registry::Error
    Chef::Log.debug("Firefox Registry Path did not exist: #{path}")
    return nil
  end

  begin
    _, regVal = reg.read(key) # will return something like 78.0.2 (x64 en-US)
  rescue Win32::Registry::Error
    Chef::Log.debug("Firefox Registry Key did not exist: #{key}")
    return nil
  end

  matchData = /^([0-9\.]+)/.match(regVal) # grab just the 78.0.2 from the string
  # rubocop:disable Style/ZeroLengthPredicate
  if matchData.nil? || matchData.length == 0
    Chef::Log.debug('Match Data is nil or empty')
    return nil
  end

  return matchData[0]
end
