# Returns the path to the Java Exe
# Provide the root path to where Java was installed
# Folder structure example: C:\Program Files\Amazon Corretto\jdk1.8.0_265\bin\java.exe
# "jdk1.8.0_265" is the dynamic piece that changes based on version, which this looks up
def get_java_path(rootPath)
  if Dir.exist?(rootPath) == false
    raise "Java Directory #{rootPath} not found"
  end

  # Look for any directory within the root path that starts with jdk
  Dir.entries(rootPath).select do |entry|
    if entry.start_with?('jdk')
      return "#{rootPath}\\#{entry}\\bin\\java.exe"
    end
  end

  raise "Unable to find a folder starting with jdk in #{rootPath}"
end

# Returns the installed java version
# Cannot use tools like wmic, as that uses the openjdk version and doesn't match the corretto version :(
def getJavaVersion
  versionFilePath = node['jdk']['path'] + '\VERSION.txt'
  if File.exist?(versionFilePath) == false
    return nil
  end
  return File.read(versionFilePath)
end

# Closes any running process of Java
def close_java
  require 'sys/proctable'

  # Loop through all processes, looking for Java
  pid = nil
  Sys::ProcTable.ps do |p|
    if p.comm == 'java.exe'
      pid = p.pid
      break
    end
  end

  if pid.nil?
    Chef::Log.info('Could not find Java running. Skipping exit')
    return
  end
  Process.kill('KILL', pid)
end
