# Return the version of the install cbg bin
def cbg_version
  versionFilePath = node['cbg']['path'] + '\VERSION.txt'
  if File.exist?(versionFilePath) == false
    return nil
  end
  return File.read(versionFilePath)
end

# Returns the windows user account password from Sandstorm
def windowsPassword
  sandstormPath = 'C:\Program Files\sandstorm\sandstorm.exe'
  roleARN = 'arn:aws:iam::734326455073:role/sandstorm/production/templated/role/qe-prod-grid'
  passwordItemName = 'qa-eng/grid/production/windows-10-password'

  # Make a system call to sandstorm
  # rubocop:disable Style/Semicolon
  password = `"#{sandstormPath}" get -n --role-arn "#{roleARN}" "#{passwordItemName}"`; result = $CHILD_STATUS.success?

  # If successful result and password is not empty
  if result && password.to_s.strip.empty? == false
    return password
  else
    raise 'Error fetching Windows password from Sandstorm'
  end
end
