# Returns the currently downloaded Selenium Version
# This is based off the file name within the Selenium Storage Path
# Returns nil if not installed, or an unexpected error occurs
def selenium_version
  # return the version after selenium-server, example
  # selenium-server-4.0.0-prerelease-beta-1-6eecd00e79.jar will return 4.0.0-prerelease-beta-1-6eecd00e79
  regex = /selenium-server-(.*)\.jar/

  # Find selenium-server jar within the selenium path
  begin
    results = Dir.entries(node['se']['path']).grep(regex)
  rescue Errno::ENOENT # directory doesn't exist
    Chef::Log.debug('Selenium path does not exist. Returning nil for selenium version')
    return nil
  end

  if results.length != 1 # there should only be 1. If not 1...
    if results.length > 1
      Chef::Log.error("Unexpected return of multiple Selenium versions. Expected 1, got: #{results.length}: #{results}")
    end
    return nil # will return this if 0, meaning Selenium isn't installed
  else
    return results[0][regex, 1] # return first result with the first match of the regex
  end
end
