#
# Cookbook:: grid_node
# Recipe:: chrome
#

desiredVersion = node['chrome']['version']
folderName = 'GoogleChromeEnterpriseBundle64'
storagePath = Chef::Config['file_cache_path']
# store a copy of version so it doesn't have to keep looking up directories.
# This method, chrome_version, is from the chrome supermarket package
chromeVersion = chrome_version()
chromeVersionChange = chromeVersion != desiredVersion # boolean if the version is changing in this run

Chef::Log.info("Configuring Google Chrome version #{desiredVersion}")

# Download the zip bundle of the version
aws_s3_file "#{storagePath}\\#{folderName}.zip" do
  action :create
  bucket 'grid-artifacts'
  remote_path "chrome/#{desiredVersion}/#{folderName}.zip"
  region 'us-west-2'
end

archive_file "#{storagePath}\\#{folderName}.zip" do
  action :extract
  destination "#{storagePath}\\#{folderName}"
end

# Remove Google Chrome if Chrome is installed and the version doesn't equal the desired version
windows_package 'Google Chrome' do
  action :remove
  only_if { !chromeVersion.nil? && chromeVersionChange }
end

# Install Google Chrome
windows_package 'Google Chrome' do
  action :install
  source "#{storagePath}\\#{folderName}\\Installers\\GoogleChromeStandaloneEnterprise64.msi"
end

# Delete the update folder to prevent chrome from updating
# Does not work with chef's directory resource
# https://github.com/Esri/arcgis-cookbook/issues/192
powershell_script 'disable_chrome_update' do
  action :run
  code <<-EOF
    Stop-Process -Name "Google*" -Force # Stop chrome processes so that the update folder is no longer in use
    Remove-Item -Recurse -Force -Path "C:\\Program Files (x86)\\Google\\Update"
  EOF
  retries 40
  retry_delay 1
end

# Clean Up
directory "#{storagePath}\\#{folderName}" do
  action :delete
  recursive true
end

file "#{storagePath}\\#{folderName}.zip" do
  action :delete
end
