#
# Cookbook:: grid_node
# Recipe:: chromedriver
#

desiredChromeDriverVersion = node['chromedriver']['version']
cdStoragePath = node['config_directory'] + '\chromedriver_win32'
installedChromedriverVersion = chromedriver_version()

Chef::Log.info("Configuring Chromedriver version #{desiredChromeDriverVersion}")

# Remove existing only if we are changing the version
directory cdStoragePath do
  action :delete
  only_if { !installedChromedriverVersion.nil? && installedChromedriverVersion != desiredChromeDriverVersion }
  recursive true
end

aws_s3_file "#{cdStoragePath}.zip" do
  action :create
  bucket 'grid-artifacts'
  remote_path "chrome/chromedriver/#{desiredChromeDriverVersion}/chromedriver_win32.zip"
  region 'us-west-2'
end

archive_file "#{cdStoragePath}.zip" do
  action :extract
  destination cdStoragePath
end

# Create a VERSION file to help determine what version is currently installed
file "#{cdStoragePath}/VERSION.txt" do
  content desiredChromeDriverVersion
  mode '0755'
  owner 'selenium'
end
