#
# Cookbook:: grid_node
# Recipe:: cloudwatch_agent
#

Chef::Log.info('Configuring Amazon Cloudwatch Agent')

configDestination = 'C:\ProgramData\Amazon\AmazonCloudWatchAgent\Configs\amazon-cloudwatch-agent.json'

windows_package 'Amazon Cloudwatch Agent' do
  action :install
  installer_type :msi
  source 'https://s3.amazonaws.com/amazoncloudwatch-agent/windows/amd64/latest/amazon-cloudwatch-agent.msi'
end

cookbook_file configDestination do
  source 'amazon-cloudwatch-agent.json'
  owner  'selenium'
  group  'Administrators'
  mode   '0777'
  action :create
end

powershell_script 'load_config' do
  code <<-EOH
    & "C:\\Program Files\\Amazon\\AmazonCloudWatchAgent\\amazon-cloudwatch-agent-ctl.ps1" -a fetch-config -m ec2 -s -c file:#{configDestination}
  EOH
end
