#
# Cookbook:: grid_node
# Recipe:: default
#

Chef::Log.info('Configuring Grid Node')

include_recipe 'grid_node::cloudwatch_agent'
include_recipe 'grid_node::chrome'       if chrome_version != node['chrome']['version']
include_recipe 'grid_node::chromedriver' if chromedriver_version != node['chromedriver']['version']
include_recipe 'grid_node::firefox'      if firefox_version() != node['firefox']['version']
include_recipe 'grid_node::geckodriver'  if geckodriver_version() != node['geckodriver']['version']
include_recipe 'grid_node::jdk'

if node['ec2']['tags'].dig('SeMajorVersion') == '4'
  include_recipe 'grid_node::selenium_4'
else
  include_recipe 'grid_node::selenium'
end
