#
# Cookbook:: grid_node
# Recipe:: firefox
#

desiredVersion = node['firefox']['version']
currentVersion = firefox_version()
setupFileName  = "Firefox Setup #{desiredVersion}.exe"
storagePath = Chef::Config['file_cache_path']

Chef::Log.info("Configuring Firefox version #{desiredVersion}")

# Download the zip bundle of the version
aws_s3_file "#{storagePath}\\#{setupFileName}" do
  action :create
  bucket 'grid-artifacts'
  remote_path "firefox/win64/#{setupFileName}"
  region 'us-west-2'
end

# If downgrading/upgrading, remove existing profiles settings - downgrading creates errors
# No uninstall available for the Firefox windows_package - it's not removing it for some reason
directory 'C:\Users\selenium\AppData\Roaming\Mozilla\Firefox' do
  action :delete
  recursive true
  only_if { !currentVersion.nil? && desiredVersion != currentVersion }
end

# Install Firefox
windows_package "Mozilla Firefox #{desiredVersion} (x64 en-US)" do
  action :install
  installer_type :custom
  options '-ms'
  source "#{storagePath}\\#{setupFileName}"
end

# Clean Up
file "#{storagePath}\\#{setupFileName}" do
  action :delete
end

# https://github.com/mozilla/geckodriver/issues/1811#issuecomment-743755597
windows_env 'MOZ_PROFILER_STARTUP' do
  action :delete
  value '1'
end

# https://github.com/mozilla/geckodriver/issues/1811#issuecomment-743755597
windows_env 'MOZ_PROFILER_SHUTDOWN' do
  action :delete
  value 'C:\Users\selenium\AppData\Local\Twitch\Grid\Logs\ffprofiler.json'
end
