#
# Cookbook:: grid_node
# Recipe:: geckodriver
#

desiredVersion = node['geckodriver']['version']
filename = "geckodriver-v#{desiredVersion}-win64.zip"
cdStoragePath = node['config_directory']
extractPath = "#{cdStoragePath}\\geckodriver"

installedVersion = geckodriver_version()

Chef::Log.info("Configuring Geckodriver version #{desiredVersion}")

aws_s3_file "#{cdStoragePath}\\#{filename}" do
  action :create
  bucket 'grid-artifacts'
  remote_path "firefox/geckodriver/#{desiredVersion}/#{filename}"
  region 'us-west-2'
end

# Remove existing only if we are changing the version
# This is placed beneath aws_s3_file to ensure the new desired version exists
# If it errors, at least we keep the existing geckodriver on the machine
directory extractPath do
  action :delete
  only_if { !installedVersion.nil? && installedVersion != desiredVersion }
  recursive true
end

archive_file "#{cdStoragePath}\\#{filename}" do
  action :extract
  destination extractPath
end

# Create a VERSION file to help determine what version is currently installed
file "#{extractPath}/VERSION.txt" do
  content desiredVersion
  mode '0755'
  owner 'selenium'
end

# Cleanup
file "#{cdStoragePath}\\#{filename}" do
  action :delete
end
