#
# Cookbook:: grid_node
# Recipe:: java
#

package = 'amazon-corretto-8-x64-windows-jdk.msi'
cdStoragePath = node['config_directory']
installationDirectory = node['jdk']['path']
desiredVersion = node['jdk']['version']
versionChange = !getJavaVersion.nil? && getJavaVersion != desiredVersion # installed (not-nil) and changing version

# To be able to close java
chef_gem 'sys-proctable' do
  action :install
end

aws_s3_file "#{cdStoragePath}/amazon-corretto-#{desiredVersion}-windows-x64.msi" do
  action :create
  bucket 'grid-artifacts'
  remote_path "jdk/amazon-corretto-#{desiredVersion}-windows-x64.msi"
  region 'us-west-2'
end

ruby_block 'close_java' do
  action :run
  block do
    close_java()
  end
  only_if { versionChange }
  notifies :run, 'windows_task[relaunch_selenium]', :delayed
end

windows_package package do
  action :install
  installer_type :msi
  source "#{cdStoragePath}/amazon-corretto-#{desiredVersion}-windows-x64.msi"
  options "INSTALLDIR=\"#{installationDirectory}\""
  only_if { getJavaVersion.nil? || versionChange }
end

# Create a VERSION file to help determine what version is currently installed
# Using wmic to get version doesn't match the version of corretto we get :(
file "#{installationDirectory}/VERSION.txt" do
  content desiredVersion
  mode '0755'
  owner 'selenium'
  group 'Administrator'
end

windows_firewall_rule 'OpenJDK Platform binary' do
  description          'JDK used for Selenium Grid'
  direction            :inbound
  enabled              true
  firewall_action      :allow
  profile              :any
  program              lazy { get_java_path(installationDirectory) }
  action               :create
end
