#
# Cookbook:: grid_node
# Recipe:: selenium
#

desiredVersion   = node['se']['version']
cdStoragePath    = node['se']['path']
installedVersion = selenium_version()
versionChange    = !installedVersion.nil? && installedVersion != desiredVersion # if installed, and versions changing

Chef::Log.info("Configuring Selenium version #{desiredVersion}. Version Change: #{versionChange}")

# To be able to close java
chef_gem 'sys-proctable' do
  action :install
end

ruby_block 'close_java' do
  action :run
  block do
    close_java()
  end
  only_if { versionChange }
  notifies :run, 'windows_task[relaunch_selenium]', :delayed
end

directory cdStoragePath do
  action :create
  recursive true
  mode  '0755'
  owner 'selenium'
  group 'Administrators'
end

file "#{cdStoragePath}/selenium-server-#{installedVersion}.jar" do
  action :delete
  only_if { versionChange }
end

aws_s3_file "#{cdStoragePath}/selenium-server-#{desiredVersion}.jar" do
  action :create
  bucket 'grid-artifacts'
  remote_path "selenium/selenium-server-#{desiredVersion}.jar"
  region 'us-west-2'
  mode  '0777'
  owner 'selenium'
  group 'Administrators'
end

cookbook_file "#{cdStoragePath}/se4_config.toml" do
  source 'se4_config.toml'
  owner  'selenium'
  group  'Administrators'
  mode   '0755'
  action :create
end

cookbook_file "#{node['config_directory']}/launch_selenium_4.ps1" do
  source 'launch_selenium_4.ps1'
  owner  'selenium'
  group  'Administrators'
  mode   '0777'
  action :create
end

# Register job to start up if it's the first time installing
windows_task 'selenium_startup' do
  action :create
  command "powershell -File #{node['config_directory']}\\launch.ps1 #{desiredVersion}"
  description 'Launch Selenium on Windows Startup'
  frequency :on_logon
  user      'selenium'
  password  windowsPassword()
  sensitive true
end

# Relaunch Selenium if there was a version change (and this isn't the first install)
windows_task 'relaunch_selenium' do
  action :create
  command "powershell -File #{node['config_directory']}\\launch.ps1 #{desiredVersion}"
  description 'Launch Selenium'
  start_when_available true
  frequency :none
  user      'selenium'
  password  windowsPassword()
  sensitive true
end
