### Windows 10

#### Base Image
The process begins with defining a base image for AWS to utilize.
This section was influenced by [this article](http://huestones.co.uk/node/305).

We are currently using a [Windows 10 Enterprise ISO Image](https://www.dropbox.com/s/x5yjuyn501ds9br/SW_DVD5_WIN_ENT_10_64BIT_English_MLF_X20-26061.ISO?dl=0).

1) Download Image and VirtualBox
2) Create a new Virtual Box Image, put Windows 10 in the name for it to figure out the type
3) Set Base Memory to 3500 MB, the lowest C4 Instance Type's memory (AWS likely can expand this on demand)
4) Create a Virtual Hard Disk (VDI) that's Dynamically Allocated
5) Set Hard Drive Size to 32GB and click Create
6) Go into the Virtual Box settings of the created VM
7) Under "Display" enable 3D and 2D Acceleration
8) Under "Storage" click Controller: SATA, and click the little disk image next to it. Select the ISO Image from above
9) Delete the unused image
10) Disable Audio

Click Ok to save the settings and then start the machine. You should see Windows 10 Installation.
Follow the installation, make sure **not** to use Express Settings. Disable all of the Personalization/Tracking/Error Reporting

Create a user as:
- Username: `selenium`
- Password: (fetch from sandstorm)

When the user has finished created:
1) Remove the disk from the drive
2) Install all Windows Updates
3) Go into Control Panel > Programs and Features > Turn Windows features on or off and installed .NET framework 3.5.
4) Disable UAC1: Do this from Control Panel > User Accounts > Change user account control settings, drop the slider to the bottom, Never notify. Additionally open an administrator command prompt window: Type cmd in the windows search bar, right-click and choose Run as administrator on the Command Prompt app. Then type the following and press enter
```
reg add HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Policies\System /v EnableLUA /d 0 /t REG_DWORD /f /reg:64
```
5) Set the network to Private. Click on the Ethernet network in the Task Bar, click on it within the Network Settings window that appears, and click "Allow Discovery"
6) Configure and Enable WinRM. In the administrator command prompt, paste and hit enter for each line:
```
winrm quickconfig -q 
 
winrm set winrm/config/winrs @{MaxMemoryPerShellMB="512"} 
 
winrm set winrm/config @{MaxTimeoutms="1800000"} 
 
winrm set winrm/config/service @{AllowUnencrypted="true"} 
 
winrm set winrm/config/service/auth @{Basic="true"} 
 
sc config WinRM start= auto
```
The last line configures winrm services to start automatically. This will allow Vagrant to connect to the box and control it. WinRm is the alternative to ssh for windows boxes.

7) Relax the Powershell execution policy2: Run Powershell as Administrator and execute this command:
```
Set-ExecutionPolicy -ExecutionPolicy Unrestricted
```

8) Enable remote connection to your box: Control Panel > System > Advanced System Settings > Remote > Allow remote connections to this computer, uncheck the Only allow ... NLA checkbox

9) Uninstall One Drive and any other unnecessary programs (VirtualBox Additions if you installed it)

10) clean unused files and zero free space on C drive2. Type into Command Prompt:
```
C:\Windows\System32\cleanmgr.exe /d c:
```

11) Restart the virtual machine, make sure all updates have finished installing
12) Shut the machine down

##### Importing the VM into AWS

[Reference Link](http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html)

With the machine shut down, export the image from Virtualbox.

1) Within Virtualbox, go to File / Export Appliance
2) Select the VM you just created
3) Keep extension to Open Virtualization Format Archive (OVA)
4) Set format to OVF 1.0. Leave "Write Manifest File" unchecked.
5) Click Export

When finished exporting
1) Upload the .OVA file to AWS S3
2) Create a containers.json file with the following:
```
[
  {
    "Description": "Windows 10 Base 10/17/2017",
    "Format": "ova",
    "UserBucket": {
        "S3Bucket": "vm-dylan-test",
        "S3Key": "Windows_10_Base_10_17_2017.ova"
    }
  }
]
```

S3Key should be the name of the .ova file you uploaded to S3. S3Bucket should be the bucket you uploaded to.

3) Import with the following command (making sure you are CD'd into the directory of containers.json):
```
aws ec2 import-image --license-type BYOL --disk-containers file://containers.json --profile twitch-cape-qe-aws
```

4) Wait for the AMI to completely process. You can check on the status using:
`aws ec2 describe-import-image-tasks --profile twitch-cape-qe-aws --import-task-ids my_task_id`

Be sure you replace `my_task_id` with the "ImportTaskId" that was returned from the previous command.


##### Running UserData on Admin Account

After importing the VM, any UserData will run on the System account. We need to run this on the local Administrator account.

To do so, we'll need to create a new AMI based off the imported VM.

1) Launch an Instance with the AMI Image from the previous steps
2) Log into the Selenium User

We're going to allow for Selenium Account to auto login so that the UserData can launch a GUI Application on its desktop.

1) Open Command Prompt as Administrator and enter: `netplwiz`
2) Click on the selenium account in the list
3) Uncheck "Users must enter a user name and password to use this computer"
4) Click Ok
5) Enter the Selenium Account password

Next, enable ENA:
http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking-ena.html

Finishing touches:
1) Launch `EC2ConfigService Settings` from the Start Menu
2) Under General, check the box "Enable UserData execution for next service start
3) Under Image, select "Administrator Password: Random"
4) Click Apply, and then click "Shutdown Without Sysprep"
5) When the instance reports as Stopped, right click the instance, go to image, and click Create AMI
6) When the AMI finishes creating, you can terminate the instance

At this point, the base image should be configured.
