# This script will grab all Grid instances and take a screenshot of the online instances
# Saves images in this folder
require 'aws-sdk'

client = Aws::EC2::Client.new(region: 'us-west-2', profile: 'twitch-cape-qe-aws')

# Make a request for the described instances
described_instances = client.describe_instances(filters: [{ name: 'tag:Service', values: ['grid'] },
                                                          { name: 'tag:Environment', values: ['prod']}] )

total_count = described_instances.reservations.length # The total amount of reservations, used for counting

described_instances.reservations.each_with_index do |res, index|
  begin
    instance = res.instances[0] # Access the instance
    next if instance.state.name != 'running' # Skip offline instances
    id = instance.instance_id
    puts "[INFO]: (#{index}/#{total_count}): Grabbing screenshot for Instance ID: #{id}"

    # Make a request for the screenshot
    resp = client.get_console_screenshot({
     dry_run: false,
     instance_id: id,
     wake_up: true, # acts as keystroke input and wakes up an instance that's in standby or "sleep" mode.
   })

    data = Base64.decode64(resp.image_data) # Data comes back Base64 Encoded, Decode it
    IO.binwrite("#{resp.instance_id}.jpg", data) # Write it to a binary file
  rescue Exception => e
    puts "[WARN] Encountered #{e.class} - #{e.message}"
    exit if Interrupt # User tried to exit
    next
  end
end
