# This Script with build a nodeConfig.json file
# The capabilities depends on if the node tests Browsers or Desktop Applications

$ErrorActionPreference = "Stop" # Stop on any error
$config_directory = "C:\ProgramData\grid-config"

# Main Function - Entry point
function main {
    # Load the Configuration Files
    $base = load-config("$config_directory\baseConfig.json")
    $caps = load-config(find-capability-file)

    # Merge them
    merge $base $caps

    # Write the merged output to a file, in JSON Format
    $base | ConvertTo-Json | Out-File -filepath "$config_directory\nodeConfig.json" -Encoding "ASCII"
}

# Loads a JSON Configuration File and returns an object
function load-config($file) {
    return Get-Content -path $file -raw -Encoding "ASCII" | ConvertFrom-Json
}

# Returns the proper capability file to use, depending if the node is for desktop or browser testing
function find-capability-file() {
    $desktopSupport = Get-AWS-Tag "DesktopAppSupport"

    # Determine what file to load depending on the AWS Tags
    if ($desktopSupport -eq "true" ) {
        $file = "$config_directory\desktopCaps.json"
    } else {
        $file = "$config_directory\browserCaps.json"
    }

    return $file
}

# Merges two objects together. Source will override Target's properties
function merge ($target, $source) {
    $source.psobject.Properties | % {
        if ($_.TypeNameOfValue -eq 'System.Management.Automation.PSCustomObject' -and $target."$($_.Name)" ) {
            merge $target."$($_.Name)" $_.Value
        }
        else {
            $target | Add-Member -MemberType $_.MemberType -Name $_.Name -Value $_.Value -Force
        }
    }
}

main # Run the main function
