# This script will configure the scheduled cron jobs on the nodes

$config_directory = "C:\ProgramData\grid-config" # TODO: Store in a config file
$sandstorm_directory = "C:\Program Files\sandstorm" # TODO: Store in a config file

# Grab the account creds from Sandstorm - output it to a file
# This password will be used for registering the Startup Jobs
# Note, this is later removed below
$password_file = "$config_directory\account_pass.txt"
& "$sandstorm_directory\sandstorm.exe" get -n --role-arn "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/qe-prod-grid" "qa-eng/grid/production/windows-10-password" | Out-File -filepath $password_file

###############
# Startup Job #
###############

# Set Up Credentials
# Passing the credential to jobs as the System Account doesn't seem to have permission to create the jobs
# TODO: Modify the access level permissions of system?
$username = "selenium"
$password = Get-Content -Path $password_file -Raw
$password = $password -replace '\s', '' # Strip all whitespace, the file may include this

$securePassword = ConvertTo-SecureString $password -AsPlainText -Force
$credential = New-Object System.Management.Automation.PSCredential $username, $securePassword

############################
# Desktop Artifact Cleanup #
############################

# Schedule a Job for Desktop Artifact Cleanup if the node supports Desktop Applications
if ($(Get-AWS-Tag "DesktopAppSupport") -eq "true" ) {
    Write-Log -level "INFO" -message "Registering Delete Desktop Artifact Job"

    $date = Get-Date -Date "2am -0800" # Run at 2am Pacific Standard
    $desktopArtifactTrigger = New-JobTrigger -Daily -At $date

    try {
        $deleteArtifactJob = Register-ScheduledJob -Name "Delete Desktop Artifacts" -Credential $credential `
            -Trigger $desktopArtifactTrigger `
            -FilePath "$config_directory\delete_desktop_artifacts.ps1" -ErrorAction Stop
        Write-Log -level "INFO" -message "Delete Desktop Artifact Job created! ID: $($deleteArtifactJob.id)"
    } catch {
        Write-Log -level "ERROR" -message "Problem registering Delete Desktop Artifact Job. encountered exception: $($_.Exception)"
        throw $_.Exception
    }
} else {
    Write-Log -level "DEBUG" -message "Not registering Delete Desktop Artifacts job as tag 'DesktopAppSupport' was not true"
}

# Rotate Nginx Logs, every hour
try {
    $jobName = "Rotate Nginx Logs"
    $nginxTrigger = New-JobTrigger -Once -At (Get-Date) -RepetitionInterval (New-TimeSpan -Hours 1) -RepeatIndefinitely
    $nginxTriggerJob = Register-ScheduledJob -Name $jobName `
            -Trigger $nginxTrigger -Credential $credential `
            -FilePath "$config_directory\rotate_nginx_logs.ps1" -ErrorAction Stop
    Write-Log -level "INFO" -message "$jobName Job created! ID: $($nginxTriggerJob.id)"
} catch {
    Write-Log -level "ERROR" -message "Problem registering $jobName Job. encountered exception: $($_.Exception)"
    throw $_.Exception
}

#############
# Finishing #
#############

# Remove the Password File
Remove-Item -path $password_file -Force
